/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.utils;

import com.google.common.collect.Multiset;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemProvider;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.oredict.OredictHandler;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "JAOPCA Executor Thread"));
    private static final Comparator<IForgeRegistryEntry<?>> ENTRY_PREFERENCE_COMPARATOR = (entry1, entry2) -> {
        int index2;
        ResourceLocation key2;
        ResourceLocation key1 = entry1.getRegistryName();
        if (key1 == (key2 = entry2.getRegistryName())) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        int index1 = ConfigHandler.PREFERRED_MODS.indexOf(key1.func_110624_b());
        if (index1 == (index2 = ConfigHandler.PREFERRED_MODS.indexOf(key2.func_110624_b()))) {
            return 0;
        }
        if (index1 == -1) {
            return 1;
        }
        if (index2 == -1) {
            return -1;
        }
        return Integer.compare(index1, index2);
    };
    private static final Predicate<String> META_ITEM_PREDICATE = s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s.split("@(?=\\d*$)")[0]));
    private static final Predicate<String> CONFIG_MATERIAL_PREDICATE = s -> s.equals("*") || s.startsWith("*") && MaterialType.fromName(s.substring(1)) != null || MaterialHandler.containsMaterial(s);
    private static final Predicate<String> CONFIG_MODULE_PREDICATE = s -> s.equals("*") || ModuleHandler.getModuleMap().containsKey(s);

    private MiscHelper() {
    }

    @Override
    public ResourceLocation getRecipeKey(String category, String material) {
        if (StringUtils.contains((CharSequence)category, (int)58)) {
            return new ResourceLocation(category + '.' + this.toLowercaseUnderscore(material));
        }
        return new ResourceLocation("jaopca", category + '.' + this.toLowercaseUnderscore(material));
    }

    @Override
    public String getOredictName(String form, String material) {
        return form + material;
    }

    @Override
    public String getFluidName(String form, String material) {
        return form + (form.isEmpty() ? "" : "_") + this.toLowercaseUnderscore(material);
    }

    @Override
    public ItemStack getItemStack(Object obj, int count) {
        if (obj instanceof Supplier) {
            return this.getItemStack(((Supplier)obj).get(), count);
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.func_190926_b()) {
                return this.resizeItemStack(stack, count);
            }
        } else {
            if (obj instanceof Item && obj != Items.field_190931_a) {
                return new ItemStack((Item)obj, count);
            }
            if (obj instanceof Block && obj != Blocks.field_150350_a) {
                return new ItemStack((Block)obj, count);
            }
            if (obj instanceof IItemProvider) {
                Item item = ((IItemProvider)obj).asItem();
                if (item != Items.field_190931_a) {
                    return new ItemStack(item, count);
                }
            } else if (obj instanceof String && OredictHandler.getOredict().contains(obj)) {
                return this.getPreferredItemStack(Arrays.asList(new OreIngredient((String)obj).func_193365_a()), count);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Ingredient getIngredient(Object obj) {
        if (obj instanceof Supplier) {
            return this.getIngredient(((Supplier)obj).get());
        }
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof String) {
            if (OredictHandler.getOredict().contains(obj)) {
                return new OreIngredient((String)obj);
            }
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.func_190926_b()) {
                return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            }
        } else {
            if (obj instanceof Item) {
                return Ingredient.func_193367_a((Item)((Item)obj));
            }
            if (obj instanceof Block) {
                return Ingredient.func_193367_a((Item)Item.func_150898_a((Block)((Block)obj)));
            }
            if (obj instanceof IItemProvider) {
                return Ingredient.func_193367_a((Item)((IItemProvider)obj).asItem());
            }
        }
        return null;
    }

    @Override
    public ItemStack getPreferredItemStack(Iterable<ItemStack> iterable, int count) {
        Optional<ItemStack> preferredEntry = Streams.stream(iterable).min(Comparator.comparing(ItemStack::func_77973_b, this.entryPreferenceComparator()));
        return preferredEntry.map(stack -> this.resizeItemStack((ItemStack)stack, count)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ItemStack resizeItemStack(ItemStack stack, int count) {
        if (stack != null && !stack.func_190926_b()) {
            ItemStack ret = stack.func_77946_l();
            ret.func_190920_e(count);
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public FluidStack getFluidStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getFluidStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof FluidStack) {
            return this.resizeFluidStack((FluidStack)obj, amount);
        }
        if (obj instanceof Fluid) {
            return new FluidStack((Fluid)obj, amount);
        }
        if (obj instanceof IFluidProvider) {
            return new FluidStack(((IFluidProvider)obj).asFluid(), amount);
        }
        if (obj instanceof String) {
            return FluidRegistry.getFluidStack((String)((String)obj), (int)amount);
        }
        return null;
    }

    @Override
    public FluidStack resizeFluidStack(FluidStack stack, int amount) {
        if (stack != null) {
            FluidStack ret = stack.copy();
            ret.amount = amount;
            return ret;
        }
        return null;
    }

    @Override
    public Comparator<IForgeRegistryEntry<?>> entryPreferenceComparator() {
        return ENTRY_PREFERENCE_COMPARATOR;
    }

    @Override
    public Predicate<String> metaItemPredicate() {
        return META_ITEM_PREDICATE;
    }

    @Override
    public ItemStack parseMetaItem(String str) {
        String[] split = str.split("@(?=\\d*$)");
        int meta = 0;
        if (split.length == 2) {
            meta = Optional.ofNullable(Ints.tryParse((String)split[1])).orElse(0);
        }
        return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0])), 1, meta);
    }

    @Override
    public String toLowercaseUnderscore(String camelCase) {
        if (StringUtils.isEmpty((CharSequence)camelCase)) {
            return "";
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String s : StringUtils.splitByCharacterTypeCamelCase((String)camelCase)) {
            if (StringUtils.isAllUpperCase((CharSequence)s)) {
                list.add(s.toLowerCase(Locale.US).chars().mapToObj(c -> String.valueOf((char)c)).collect(Collectors.joining("_")));
                continue;
            }
            if (StringUtils.isAllLowerCase((CharSequence)s) && !list.isEmpty()) {
                list.add((String)list.pollLast() + s);
                continue;
            }
            list.add(StringUtils.uncapitalize((String)s));
        }
        return String.join((CharSequence)"_", list);
    }

    @Override
    public void caclulateMaterialSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = configList.stream().map(s -> s.startsWith("*") ? s.toLowerCase(Locale.US) : s).collect(Collectors.toCollection(TreeMultiset::create));
        int listCount = list.count((Object)"*");
        MaterialHandler.getMaterials().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        for (MaterialType type : MaterialType.values()) {
            int listCount1 = list.count((Object)("*" + type.getName()));
            MaterialHandler.getMaterials().stream().filter(m -> m.getType() == type).forEach(m -> list.add((Object)m.getName(), listCount1));
            list.remove((Object)("*" + type.getName()), listCount1);
        }
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public void caclulateModuleSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        ModuleHandler.getModules().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public Predicate<String> configMaterialPredicate() {
        return CONFIG_MATERIAL_PREDICATE;
    }

    @Override
    public Predicate<String> configModulePredicate() {
        return CONFIG_MODULE_PREDICATE;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    @Override
    public boolean hasResource(ResourceLocation location) {
        return (Boolean)this.conditionalSupplier(() -> ((Side)FMLCommonHandler.instance().getSide()).isClient(), () -> () -> {
            try {
                return Minecraft.func_71410_x().func_110442_L().func_110536_a(location) != null;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> () -> false).get();
    }

    public <T> Future<T> submitAsyncTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submitAsyncTask(Runnable task) {
        return this.executor.submit(task);
    }

    public int squareColorDifference(int color1, int color2) {
        int diffR = (color1 << 16 & 0xFF) - (color2 << 16 & 0xFF);
        int diffG = (color1 << 8 & 0xFF) - (color2 << 8 & 0xFF);
        int diffB = (color1 & 0xFF) - (color2 & 0xFF);
        return diffR * diffR + diffG * diffG + diffB * diffB;
    }

    public Predicate<String> modVersionNotLoaded(Logger logger) {
        return dep -> {
            VersionRange versionRange;
            Loader modLoader = Loader.instance();
            int separatorIndex = dep.lastIndexOf(64);
            String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
            String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1);
            try {
                versionRange = VersionRange.createFromVersionSpec((String)spec);
            }
            catch (InvalidVersionSpecificationException e) {
                logger.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
                return true;
            }
            if (Loader.isModLoaded((String)modId)) {
                ArtifactVersion version = ((ModContainer)modLoader.getIndexedModList().get(modId)).getProcessedVersion();
                if (versionRange.containsVersion(version)) {
                    return false;
                }
                logger.warn("Mod {} in version range {} was requested, was {}", (Object)modId, (Object)versionRange, (Object)version);
                return true;
            }
            return true;
        };
    }

    public boolean classNotExists(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }
}

