package thelm.jaopca.api.custom;

import java.util.Arrays;
import java.util.Locale;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.SoundType;

public enum VanillaSoundType implements StringRepresentable {
	EMPTY(SoundType.EMPTY),
	WOOD(SoundType.WOOD),
	GRAVEL(SoundType.GRAVEL),
	GRASS(SoundType.GRASS),
	LILY_PAD(SoundType.LILY_PAD),
	STONE(SoundType.STONE),
	METAL(SoundType.METAL),
	GLASS(SoundType.GLASS),
	WOOL(SoundType.WOOL),
	SAND(SoundType.SAND),
	SNOW(SoundType.SNOW),
	POWDER_SNOW(SoundType.POWDER_SNOW),
	LADDER(SoundType.LADDER),
	ANVIL(SoundType.ANVIL),
	SLIME_BLOCK(SoundType.SLIME_BLOCK),
	HONEY_BLOCK(SoundType.HONEY_BLOCK),
	WET_GRASS(SoundType.WET_GRASS),
	CORAL_BLOCK(SoundType.CORAL_BLOCK),
	BAMBOO(SoundType.BAMBOO),
	BAMBOO_SAPLING(SoundType.BAMBOO_SAPLING),
	SCAFFOLDING(SoundType.SCAFFOLDING),
	SWEET_BERRY_BUSH(SoundType.SWEET_BERRY_BUSH),
	CROP(SoundType.CROP),
	HARD_CROP(SoundType.HARD_CROP),
	VINE(SoundType.VINE),
	NETHER_WART(SoundType.NETHER_WART),
	LANTERN(SoundType.LANTERN),
	STEM(SoundType.STEM),
	NYLIUM(SoundType.NYLIUM),
	FUNGUS(SoundType.FUNGUS),
	ROOTS(SoundType.ROOTS),
	SHROOMLIGHT(SoundType.SHROOMLIGHT),
	WEEPING_VINES(SoundType.WEEPING_VINES),
	TWISTING_VINES(SoundType.TWISTING_VINES),
	SOUL_SAND(SoundType.SOUL_SAND),
	SOUL_SOIL(SoundType.SOUL_SOIL),
	BASALT(SoundType.BASALT),
	WART_BLOCK(SoundType.WART_BLOCK),
	NETHERRACK(SoundType.NETHERRACK),
	NETHER_BRICKS(SoundType.NETHER_BRICKS),
	NETHER_SPROUTS(SoundType.NETHER_SPROUTS),
	NETHER_ORE(SoundType.NETHER_ORE),
	BONE_BLOCK(SoundType.BONE_BLOCK),
	NETHERITE_BLOCK(SoundType.NETHERITE_BLOCK),
	ANCIENT_DEBRIS(SoundType.ANCIENT_DEBRIS),
	LODESTONE(SoundType.LODESTONE),
	CHAIN(SoundType.CHAIN),
	NETHER_GOLD_ORE(SoundType.NETHER_GOLD_ORE),
	GILDED_BLACKSTONE(SoundType.GILDED_BLACKSTONE),
	CANDLE(SoundType.CANDLE),
	AMETHYST(SoundType.AMETHYST),
	AMETHYST_CLUSTER(SoundType.AMETHYST_CLUSTER),
	SMALL_AMETHYST_BUD(SoundType.SMALL_AMETHYST_BUD),
	MEDIUM_AMETHYST_BUD(SoundType.MEDIUM_AMETHYST_BUD),
	LARGE_AMETHYST_BUD(SoundType.LARGE_AMETHYST_BUD),
	TUFF(SoundType.TUFF),
	TUFF_BRICKS(SoundType.TUFF_BRICKS),
	POLISHED_TUFF(SoundType.POLISHED_TUFF),
	CALCITE(SoundType.CALCITE),
	DRIPSTONE_BLOCK(SoundType.DRIPSTONE_BLOCK),
	POINTED_DRIPSTONE(SoundType.POINTED_DRIPSTONE),
	COPPER(SoundType.COPPER),
	COPPER_BULB(SoundType.COPPER_BULB),
	COPPER_GRATE(SoundType.COPPER_GRATE),
	CAVE_VINES(SoundType.CAVE_VINES),
	SPORE_BLOSSOM(SoundType.SPORE_BLOSSOM),
	AZALEA(SoundType.AZALEA),
	FLOWERING_AZALEA(SoundType.FLOWERING_AZALEA),
	MOSS_CARPET(SoundType.MOSS_CARPET),
	PINK_PETALS(SoundType.PINK_PETALS),
	MOSS(SoundType.MOSS),
	BIG_DRIPLEAF(SoundType.BIG_DRIPLEAF),
	SMALL_DRIPLEAF(SoundType.SMALL_DRIPLEAF),
	ROOTED_DIRT(SoundType.ROOTED_DIRT),
	HANGING_ROOTS(SoundType.HANGING_ROOTS),
	AZALEA_LEAVES(SoundType.AZALEA_LEAVES),
	SCULK_SENSOR(SoundType.SCULK_SENSOR),
	SCULK_CATALYST(SoundType.SCULK_CATALYST),
	SCULK(SoundType.SCULK),
	SCULK_VEIN(SoundType.SCULK_VEIN),
	SCULK_SHRIEKER(SoundType.SCULK_SHRIEKER),
	GLOW_LICHEN(SoundType.GLOW_LICHEN),
	DEEPSLATE(SoundType.DEEPSLATE),
	DEEPSLATE_BRICKS(SoundType.DEEPSLATE_BRICKS),
	DEEPSLATE_TILES(SoundType.DEEPSLATE_TILES),
	POLISHED_DEEPSLATE(SoundType.POLISHED_DEEPSLATE),
	FROGLIGHT(SoundType.FROGLIGHT),
	FROGSPAWN(SoundType.FROGSPAWN),
	MANGROVE_ROOTS(SoundType.MANGROVE_ROOTS),
	MUDDY_MANGROVE_ROOTS(SoundType.MUDDY_MANGROVE_ROOTS),
	MUD(SoundType.MUD),
	MUD_BRICKS(SoundType.MUD_BRICKS),
	PACKED_MUD(SoundType.PACKED_MUD),
	HANGING_SIGN(SoundType.HANGING_SIGN),
	NETHER_WOOD_HANGING_SIGN(SoundType.NETHER_WOOD_HANGING_SIGN),
	BAMBOO_WOOD_HANGING_SIGN(SoundType.BAMBOO_WOOD_HANGING_SIGN),
	BAMBOO_WOOD(SoundType.BAMBOO_WOOD),
	NETHER_WOOD(SoundType.NETHER_WOOD),
	CHERRY_WOOD(SoundType.CHERRY_WOOD),
	CHERRY_SAPLING(SoundType.CHERRY_SAPLING),
	CHERRY_LEAVES(SoundType.CHERRY_LEAVES),
	CHERRY_WOOD_HANGING_SIGN(SoundType.CHERRY_WOOD_HANGING_SIGN),
	CHISELED_BOOKSHELF(SoundType.CHISELED_BOOKSHELF),
	SUSPICIOUS_SAND(SoundType.SUSPICIOUS_SAND),
	SUSPICIOUS_GRAVEL(SoundType.SUSPICIOUS_GRAVEL),
	DECORATED_POT(SoundType.DECORATED_POT),
	DECORATED_POT_CRACKED(SoundType.DECORATED_POT_CRACKED),
	TRIAL_SPAWNER(SoundType.TRIAL_SPAWNER),
	SPONGE(SoundType.SPONGE),
	WET_SPONGE(SoundType.WET_SPONGE);

	private final SoundType soundType;

	VanillaSoundType(SoundType soundType) {
		this.soundType = soundType;
	}

	public String getName() {
		return name().toLowerCase(Locale.US);
	}

	@Override
	public String getSerializedName() {
		return getName();
	}

	public SoundType toSoundType() {
		return soundType;
	}

	public static VanillaSoundType fromSoundType(SoundType soundType) {
		return Arrays.stream(values()).filter(t->t.soundType == soundType).findAny().orElse(EMPTY);
	}

	public static SoundType nameToSoundType(String name) {
		return Arrays.stream(values()).filter(t->t.getName().equalsIgnoreCase(name)).findAny().orElse(EMPTY).soundType;
	}

	public static String soundTypeToName(SoundType soundType) {
		return fromSoundType(soundType).getName();
	}
}
