/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.mixin;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.entity.BasicFluidHopperBlockEntity;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.util.FluidHopperUtil;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceMixin {
    @Inject(at={@At(value="HEAD")}, method={"getBurnDuration(Lnet/minecraft/world/level/block/entity/FuelValues;Lnet/minecraft/world/item/ItemStack;)I"}, cancellable=true)
    private void getFluidBurnDuration(FuelValues fuelValues, ItemStack fuel, CallbackInfoReturnable<Integer> cir) {
        BlockEntity blockEntity = (BlockEntity)this;
        BlockPos pos = blockEntity.getBlockPos();
        BasicFluidHopperBlockEntity fluidHopper = FluidHopperUtil.getHopperInsertingFluid(blockEntity.getLevel(), pos, blockEntity.getBlockState(), blockEntity, true, null);
        if (fluidHopper != null) {
            cir.setReturnValue((Object)((int)(BasicFluidHopperConfig.fuelConsumeStep() * (float)fuelValues.burnDuration(new ItemStack((ItemLike)Items.LAVA_BUCKET)))));
        }
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;isLit()Z", ordinal=2)}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)V"})
    private static boolean hasFuel(boolean isLit, @Local ServerLevel level, @Local BlockPos blockPos, @Local BlockState state, @Local AbstractFurnaceBlockEntity blockEntity) {
        return isLit || FluidHopperUtil.getHopperInsertingFluid((Level)level, blockPos, state, (BlockEntity)blockEntity, true, null) != null;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;isLit()Z", ordinal=4, shift=At.Shift.AFTER)}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)V"})
    private static void consumeFuel(ServerLevel level, BlockPos pos, BlockState blockState, AbstractFurnaceBlockEntity blockEntity, CallbackInfo cbi, @Local(ordinal=3) LocalBooleanRef b4) {
        BasicFluidHopperBlockEntity fluidHopper = FluidHopperUtil.getHopperInsertingFluid((Level)level, pos, blockState, (BlockEntity)blockEntity, true, null);
        if (fluidHopper != null && !fluidHopper.getFluidStorage().getFluidInTank(0).isEmpty() && fluidHopper.getFluidStorage().getFluidInTank(0).getFluid().arch$holder().is(BasicFluidHopper.C_FLUID_FUEL)) {
            long fuel_consume_step = (long)(BasicFluidHopperConfig.fuelConsumeStep() * (float)FluidStack.bucketAmount());
            if (fluidHopper.getFluidStorage().drain(fuel_consume_step, true).getAmount() == fuel_consume_step) {
                fluidHopper.getFluidStorage().drain(fuel_consume_step, false);
                b4.set(false);
            }
        }
    }
}

