/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.vehicle;

import com.jship.basicfluidhopper.vehicle.BasicFluidHopperMinecartEntity;
import com.jship.basicfluidhopper.vehicle.BasicFluidHopperMinecartRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.AbstractMinecartRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class BasicFluidHopperMinecartEntityRenderer
extends AbstractMinecartRenderer<BasicFluidHopperMinecartEntity, BasicFluidHopperMinecartRenderState> {
    public BasicFluidHopperMinecartEntityRenderer(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        super(context, layer);
    }

    public BasicFluidHopperMinecartRenderState createRenderState() {
        return new BasicFluidHopperMinecartRenderState();
    }

    public void extractRenderState(BasicFluidHopperMinecartEntity minecartEntity, BasicFluidHopperMinecartRenderState renderState, float f) {
        super.extractRenderState((AbstractMinecart)minecartEntity, (MinecartRenderState)renderState, f);
        renderState.fluidContents = minecartEntity.getFluidStack();
        renderState.fluidCapacity = minecartEntity.fluidStorage.getTankCapacity(0);
    }

    protected void renderMinecartContents(BasicFluidHopperMinecartRenderState renderState, BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.renderMinecartContents((MinecartRenderState)renderState, state, poseStack, buffer, packedLight);
        if (renderState.fluidContents.isEmpty()) {
            return;
        }
        TextureAtlasSprite stillSprite = FluidStackHooks.getStillTexture((FluidStack)renderState.fluidContents);
        if (stillSprite == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        FluidState fluidState = renderState.fluidContents.getFluid().defaultFluidState();
        int tintColor = FluidStackHooks.getColor((BlockAndTintGetter)level, (BlockPos)BlockPos.containing((double)renderState.posOnRail.x, (double)renderState.posOnRail.y, (double)renderState.posOnRail.z), (FluidState)fluidState);
        if ((tintColor & 0xFF000000) < 0xF000000) {
            tintColor |= 0xCF000000;
        }
        float height = Math.min(1.0f, (float)renderState.fluidContents.getAmount() / (float)renderState.fluidCapacity) * 0.3f + 0.688125f;
        VertexConsumer builder = buffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState));
        BasicFluidHopperMinecartEntityRenderer.drawVertex(builder, poseStack, 0.125f, height, 0.125f, stillSprite.getU0(), stillSprite.getV0(), packedLight, OverlayTexture.NO_OVERLAY, tintColor);
        BasicFluidHopperMinecartEntityRenderer.drawVertex(builder, poseStack, 0.125f, height, 0.875f, stillSprite.getU0(), stillSprite.getV1(), packedLight, OverlayTexture.NO_OVERLAY, tintColor);
        BasicFluidHopperMinecartEntityRenderer.drawVertex(builder, poseStack, 0.875f, height, 0.875f, stillSprite.getU1(), stillSprite.getV1(), packedLight, OverlayTexture.NO_OVERLAY, tintColor);
        BasicFluidHopperMinecartEntityRenderer.drawVertex(builder, poseStack, 0.875f, height, 0.125f, stillSprite.getU1(), stillSprite.getV0(), packedLight, OverlayTexture.NO_OVERLAY, tintColor);
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int packedOverlay, int tintColor) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setUv(u, v).setLight(packedLight).setColor(tintColor).setNormal(0.0f, 1.0f, 0.0f);
    }
}

