/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.block.entity;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.BasicFluidHopperBlock;
import com.jship.basicfluidhopper.block.entity.fabric.BasicFluidHopperBlockEntityImpl;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.fluid.FluidHopper;
import com.jship.spiritapi.api.fluid.SpiritFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_7225;

public class BasicFluidHopperBlockEntity
extends class_2586
implements FluidHopper {
    public final SpiritFluidStorage fluidStorage = SpiritFluidStorage.create((long)(FluidStack.bucketAmount() * (long)BasicFluidHopperConfig.hopperCapacity()), (long)((long)((float)FluidStack.bucketAmount() * BasicFluidHopperConfig.transferRate())), () -> {
        if (!this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
        this.markDirty();
    });
    private int transferCooldown = -1;
    private int milkingCooldown = -1;

    public BasicFluidHopperBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK_ENTITY.get(), pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluidStorage.deserializeNbt(registryLookup, nbt);
        this.transferCooldown = nbt.method_10550("transfer_cooldown");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10543(this.fluidStorage.serializeNbt(registryLookup));
        nbt.method_10569("transfer_cooldown", this.transferCooldown);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Override
    public SpiritFluidStorage getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.method_11010().method_11654((class_2769)BasicFluidHopperBlock.ENABLED);
    }

    @Override
    public class_2350 getFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)BasicFluidHopperBlock.FACING);
    }

    public static void pushFluidTick(class_1937 level, class_2338 pos, class_2680 state, BasicFluidHopperBlockEntity blockEntity) {
        if (blockEntity.milkingCooldown > 0) {
            --blockEntity.milkingCooldown;
        }
        if (blockEntity.transferCooldown > 0) {
            --blockEntity.transferCooldown;
        }
        if (!blockEntity.needsCooldown()) {
            FluidHopper.fillAndDrain(level, pos, state, blockEntity);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_3611 getMilk() {
        return BasicFluidHopperBlockEntityImpl.getMilk();
    }

    public void milkEntity(class_1937 level, class_2338 pos) {
        if (this.milkingCooldown > 0) {
            return;
        }
        long inserted = this.fluidStorage.fill(FluidStack.create((class_3611)BasicFluidHopperBlockEntity.getMilk(), (long)FluidStack.bucketAmount()), true);
        if (inserted > 0L) {
            this.milkingCooldown = level.method_8409().method_39332(20, 40);
            this.fluidStorage.fill(FluidStack.create((class_3611)BasicFluidHopperBlockEntity.getMilk(), (long)FluidStack.bucketAmount()), false);
            level.method_8396(null, pos, class_3417.field_14691, class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    @Override
    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    @Override
    public boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public void markDirty() {
        this.method_5431();
    }

    public int getAnalogOutputSignal() {
        long amount = this.fluidStorage.getFluidInTank(0).getAmount();
        long limit = this.fluidStorage.getTankCapacity(0);
        return (int)(15L * amount / limit);
    }
}

