/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.fluid;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.spiritapi.api.fluid.SpiritFluidStorage;
import com.jship.spiritapi.api.fluid.SpiritFluidUtil;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8836;
import net.minecraft.class_9062;

public interface FluidHopper {
    public void markDirty();

    public SpiritFluidStorage getFluidStorage();

    public void setTransferCooldown(int var1);

    public boolean needsCooldown();

    public boolean isEnabled();

    public class_2350 getFacing();

    public static boolean fillAndDrain(class_1937 level, class_2338 pos, class_2680 state, FluidHopper fluidHopper) {
        if (level.field_9236) {
            return false;
        }
        if (!fluidHopper.needsCooldown() && fluidHopper.isEnabled() && (!fluidHopper.getFluidStorage().getFluidInTank(0).isEmpty() && FluidHopper.fill(level, pos, fluidHopper) || fluidHopper.getFluidStorage().getFluidInTank(0).getAmount() < fluidHopper.getFluidStorage().getTankCapacity(0) && FluidHopper.drain(level, pos, class_2350.field_11036, fluidHopper))) {
            fluidHopper.setTransferCooldown(BasicFluidHopperConfig.transferCooldown());
            fluidHopper.markDirty();
            return true;
        }
        return false;
    }

    public static class_9062 useFluidItem(class_1937 level, class_1657 player, class_1268 hand, FluidHopper fluidHopper) {
        if (level.field_9236) {
            return class_9062.field_47728;
        }
        class_1799 item = player.method_5998(hand);
        if (SpiritFluidUtil.isFluidItem((class_1799)item)) {
            FluidStack playerFluid = SpiritFluidUtil.getFluidFromItem((class_1799)item);
            FluidStack storageFluid = fluidHopper.getFluidStorage().getFluidInTank(0);
            if (playerFluid.isEmpty()) {
                if (SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)true)) {
                    SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)false);
                    return class_9062.field_47728;
                }
            } else if (storageFluid.getAmount() < fluidHopper.getFluidStorage().getTankCapacity(0)) {
                if (SpiritFluidUtil.drainItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)true)) {
                    SpiritFluidUtil.drainItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)false);
                    return class_9062.field_47728;
                }
            } else if (storageFluid.getAmount() >= fluidHopper.getFluidStorage().getTankCapacity(0) && SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)true)) {
                SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1657)player, (class_1268)hand, (boolean)false);
                return class_9062.field_47728;
            }
            return class_9062.field_47729;
        }
        return class_9062.field_47731;
    }

    public static boolean remove(FluidHopper fluidHopper, long amount) {
        if (fluidHopper.getFluidStorage().getFluidInTank(0).isEmpty()) {
            return false;
        }
        if (fluidHopper.getFluidStorage().drain(amount, true).getAmount() == amount) {
            fluidHopper.getFluidStorage().drain(amount, false);
            return true;
        }
        return false;
    }

    public static List<class_8836> getVehicles(class_1937 level, class_2338 pos) {
        return level.method_8335((class_1297)null, new class_238((double)pos.method_10263() - 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() - 0.5, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)).stream().filter(entity -> entity instanceof class_8836).map(entity -> (class_8836)entity).toList();
    }

    private static boolean fill(class_1937 level, class_2338 pos, FluidHopper fluidHopper) {
        long filled = SpiritFluidUtil.fillBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_2338)pos.method_10093(fluidHopper.getFacing()), (class_2350)fluidHopper.getFacing(), (boolean)true);
        if (filled > 0L) {
            SpiritFluidUtil.fillBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_2338)pos.method_10093(fluidHopper.getFacing()), (class_2350)fluidHopper.getFacing(), (boolean)false);
            return true;
        }
        for (class_8836 vehicle : FluidHopper.getVehicles(level, pos.method_10093(fluidHopper.getFacing()))) {
            filled = SpiritFluidUtil.fillVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_8836)vehicle, (boolean)true);
            if (filled <= 0L) continue;
            SpiritFluidUtil.fillVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_8836)vehicle, (boolean)false);
            return true;
        }
        return false;
    }

    public static boolean drain(class_1937 level, class_2338 pos, class_2350 facing, FluidHopper fluidHopper) {
        class_2248 bottleAmount2;
        int honey_level;
        long drained = SpiritFluidUtil.drainBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_2338)pos.method_10084(), (class_2350)facing, (boolean)true);
        if (drained > 0L) {
            SpiritFluidUtil.drainBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_2338)pos.method_10084(), (class_2350)facing, (boolean)false);
            return true;
        }
        class_2680 aboveState = level.method_8320(pos.method_10084());
        if (aboveState.method_26204() instanceof class_4481 && (honey_level = class_4482.method_23902((class_2680)aboveState)) > 0) {
            long bottleAmount2 = FluidStack.bucketAmount() / 4L;
            FluidStack honey = FluidStack.create((class_3611)((class_3611)BasicFluidHopper.HONEY_FLUID.get()), (long)bottleAmount2);
            long added = fluidHopper.getFluidStorage().fill(honey, true);
            if (added == bottleAmount2) {
                fluidHopper.getFluidStorage().fill(honey, false);
                level.method_8501(pos.method_10084(), (class_2680)aboveState.method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(honey_level - 1)));
                return true;
            }
        }
        if ((bottleAmount2 = aboveState.method_26204()) instanceof class_2263) {
            class_2263 bucketPickup = (class_2263)bottleAmount2;
            class_3610 aboveFluidState = aboveState.method_26227();
            if (aboveFluidState.method_15771()) {
                class_1799 bucket;
                FluidStack fluid = FluidStack.create((class_3611)aboveFluidState.method_15772(), (long)FluidStack.bucketAmount());
                long inserted = fluidHopper.getFluidStorage().fill(fluid, true);
                if (inserted == FluidStack.bucketAmount() && !(bucket = bucketPickup.method_9700(null, (class_1936)level, pos.method_10084(), aboveState)).method_7960()) {
                    fluidHopper.getFluidStorage().fill(fluid, false);
                    return true;
                }
            }
        }
        for (class_8836 vehicle : FluidHopper.getVehicles(level, pos.method_10084())) {
            drained = SpiritFluidUtil.drainVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_8836)vehicle, (boolean)true);
            if (drained <= 0L) continue;
            SpiritFluidUtil.drainVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (class_1937)level, (class_8836)vehicle, (boolean)false);
            return true;
        }
        return false;
    }

    public static boolean tryFillBucket(class_1799 item, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, SpiritFluidStorage fluidStorage) {
        FluidStack fluid = fluidStorage.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return false;
        }
        FluidStack removed = fluidStorage.drain(FluidStack.bucketAmount(), true);
        if (removed.getAmount() != FluidStack.bucketAmount()) {
            return false;
        }
        class_1792 bucket = fluid.getFluid().method_15774();
        class_1799 emptyBucket = player.method_5998(hand);
        if (bucket != class_1802.field_8162 && emptyBucket.method_31574(class_1802.field_8550)) {
            class_1799 bucketStack = new class_1799((class_1935)bucket);
            bucketStack.method_57365(emptyBucket.method_57353());
            player.method_6122(hand, class_5328.method_30012((class_1799)item, (class_1657)player, (class_1799)bucketStack));
            class_3414 pickupSound = bucket == class_1802.field_8187 ? class_3417.field_15202 : (bucket == BasicFluidHopper.HONEY_BUCKET.get() ? class_3417.field_20608 : class_3417.field_15126);
            level.method_8396(null, pos, pickupSound, class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596(null, (class_6880)class_5712.field_28167, pos);
            fluidStorage.drain(FluidStack.bucketAmount(), false);
            return true;
        }
        return false;
    }

    public static boolean tryDrainBucket(class_1799 item, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, SpiritFluidStorage fluidStorage) {
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof class_1755)) {
            return false;
        }
        class_1755 bucketItem = (class_1755)class_17922;
        FluidStack fluid = FluidStack.create((class_3611)bucketItem.arch$getFluid(), (long)FluidStack.bucketAmount());
        if (fluid.isEmpty()) {
            return false;
        }
        long inserted = fluidStorage.fill(fluid, true);
        if (inserted != FluidStack.bucketAmount()) {
            return false;
        }
        class_3414 bucketEmpty = item.method_31574(class_1802.field_8187) ? class_3417.field_15010 : (item.method_31574((class_1792)BasicFluidHopper.HONEY_BUCKET.get()) ? class_3417.field_20608 : class_3417.field_14834);
        level.method_8396(null, pos, bucketEmpty, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28166, pos);
        class_1799 emptyBucket = new class_1799((class_1935)class_1802.field_8550);
        emptyBucket.method_57365(bucketItem.method_57347());
        player.method_6122(hand, class_5328.method_30012((class_1799)item, (class_1657)player, (class_1799)emptyBucket));
        fluidStorage.fill(FluidStack.create((FluidStack)fluid, (long)FluidStack.bucketAmount()), false);
        return true;
    }
}

