/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.block.entity;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.BasicFluidHopperBlock;
import com.jship.basicfluidhopper.block.entity.neoforge.BasicFluidHopperBlockEntityImpl;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.fluid.FluidHopper;
import com.jship.spiritapi.api.fluid.SpiritFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class BasicFluidHopperBlockEntity
extends BlockEntity
implements FluidHopper {
    public final SpiritFluidStorage fluidStorage = SpiritFluidStorage.create((long)(FluidStack.bucketAmount() * (long)BasicFluidHopperConfig.hopperCapacity()), (long)((long)((float)FluidStack.bucketAmount() * BasicFluidHopperConfig.transferRate())), () -> {
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        this.markDirty();
    });
    private int transferCooldown = -1;
    private int milkingCooldown = -1;

    public BasicFluidHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.deserializeNbt(registryLookup, nbt);
        this.transferCooldown = nbt.getInt("transfer_cooldown");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.merge(this.fluidStorage.serializeNbt(registryLookup));
        nbt.putInt("transfer_cooldown", this.transferCooldown);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = super.getUpdateTag(registryLookup);
        this.saveAdditional(nbt, registryLookup);
        return nbt;
    }

    @Override
    public SpiritFluidStorage getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getBlockState().getValue((Property)BasicFluidHopperBlock.ENABLED);
    }

    @Override
    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BasicFluidHopperBlock.FACING);
    }

    public static void pushFluidTick(Level level, BlockPos pos, BlockState state, BasicFluidHopperBlockEntity blockEntity) {
        if (blockEntity.milkingCooldown > 0) {
            --blockEntity.milkingCooldown;
        }
        if (blockEntity.transferCooldown > 0) {
            --blockEntity.transferCooldown;
        }
        if (!blockEntity.needsCooldown()) {
            FluidHopper.fillAndDrain(level, pos, state, blockEntity);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Fluid getMilk() {
        return BasicFluidHopperBlockEntityImpl.getMilk();
    }

    public void milkEntity(Level level, BlockPos pos) {
        if (this.milkingCooldown > 0) {
            return;
        }
        long inserted = this.fluidStorage.fill(FluidStack.create((Fluid)BasicFluidHopperBlockEntity.getMilk(), (long)FluidStack.bucketAmount()), true);
        if (inserted > 0L) {
            this.milkingCooldown = level.getRandom().nextIntBetweenInclusive(20, 40);
            this.fluidStorage.fill(FluidStack.create((Fluid)BasicFluidHopperBlockEntity.getMilk(), (long)FluidStack.bucketAmount()), false);
            level.playSound(null, pos, SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Override
    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    @Override
    public boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public void markDirty() {
        this.setChanged();
    }

    public int getAnalogOutputSignal() {
        long amount = this.fluidStorage.getFluidInTank(0).getAmount();
        long limit = this.fluidStorage.getTankCapacity(0);
        return (int)(15L * amount / limit);
    }
}

