/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.neoforge;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.renderer.BasicFluidHopperBlockEntityRenderer;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.fluid.neoforge.BottleFluidHandler;
import com.jship.basicfluidhopper.vehicle.BasicFluidHopperMinecartEntityRenderer;
import com.jship.spiritapi.api.fluid.neoforge.SpiritFluidStorageImpl;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

@Mod(value="basic_fluid_hopper")
public final class BasicFluidHopperNeoforge {
    public BasicFluidHopperNeoforge(IEventBus modEventBus) {
        BasicFluidHopper.init();
        NeoForgeMod.enableMilkFluid();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> BasicFluidHopperConfig.createConfig(parent));
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerEntityRenderers);
        modEventBus.addListener(this::initializeClient);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK.get());
            event.accept((ItemLike)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ITEM.get());
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept((ItemLike)BasicFluidHopper.HONEY_BUCKET.get());
            event.accept((ItemLike)BasicFluidHopper.MILK_BOTTLE.get());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK_ENTITY.get(), (blockEntity, context) -> ((SpiritFluidStorageImpl)blockEntity.fluidStorage).neoFluidTank);
        event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ENTITY.get(), (vehicle, context) -> ((SpiritFluidStorageImpl)vehicle.fluidStorage).neoFluidTank);
        event.registerItem(Capabilities.FluidHandler.ITEM, (bottle, context) -> new BottleFluidHandler((ItemStack)bottle), new ItemLike[]{Items.POTION, Items.HONEY_BOTTLE, Items.GLASS_BOTTLE, (ItemLike)BasicFluidHopper.MILK_BOTTLE.get()});
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ENTITY.get(), context -> new BasicFluidHopperMinecartEntityRenderer(context, ModelLayers.HOPPER_MINECART));
        event.registerBlockEntityRenderer((BlockEntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK_ENTITY.get(), BasicFluidHopperBlockEntityRenderer::new);
    }

    private void initializeClient(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(this){

            @NotNull
            public ResourceLocation getStillTexture() {
                return BasicFluidHopper.HONEY_FLUID_ATTRIBUTES.getSourceTexture();
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return BasicFluidHopper.HONEY_FLUID_ATTRIBUTES.getFlowingTexture();
            }

            @NotNull
            public int getTintColor() {
                return -855715481;
            }
        }, new FluidType[]{((FlowingFluid)BasicFluidHopper.HONEY_FLUID.get()).getFluidType()});
    }
}

