/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper;

import com.google.common.base.Suppliers;
import com.jship.basicfluidhopper.block.BasicFluidHopperBlock;
import com.jship.basicfluidhopper.block.entity.BasicFluidHopperBlockEntity;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.item.MilkBottleItem;
import com.jship.basicfluidhopper.vehicle.BasicFluidHopperMinecartEntity;
import com.jship.basicfluidhopper.vehicle.BasicFluidHopperMinecartItem;
import dev.architectury.core.block.ArchitecturyLiquidBlock;
import dev.architectury.core.fluid.ArchitecturyFlowingFluid;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.SimpleArchitecturyFluidAttributes;
import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BasicFluidHopper {
    public static final String MOD_ID = "basic_fluid_hopper";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Registrar<Fluid> FLUIDS;
    public static final ArchitecturyFluidAttributes HONEY_FLUID_ATTRIBUTES;
    public static final RegistrySupplier<FlowingFluid> HONEY_FLUID;
    public static final RegistrySupplier<FlowingFluid> HONEY_FLUID_FLOWING;
    public static final Registrar<Block> BLOCKS;
    public static final RegistrySupplier<Block> BASIC_FLUID_HOPPER_BLOCK;
    public static final RegistrySupplier<LiquidBlock> HONEY_SOURCE_BLOCK;
    public static final Registrar<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final RegistrySupplier<BlockEntityType<BasicFluidHopperBlockEntity>> BASIC_FLUID_HOPPER_BLOCK_ENTITY;
    public static final Registrar<EntityType<?>> ENTITIES;
    public static final RegistrySupplier<EntityType<BasicFluidHopperMinecartEntity>> BASIC_FLUID_HOPPER_MINECART_ENTITY;
    public static final Registrar<Item> ITEMS;
    public static final RegistrySupplier<Item> BASIC_FLUID_HOPPER_ITEM;
    public static final RegistrySupplier<Item> BASIC_FLUID_HOPPER_MINECART_ITEM;
    public static final RegistrySupplier<Item> HONEY_BUCKET;
    public static final RegistrySupplier<Item> MILK_BOTTLE;
    public static final TagKey<Fluid> C_HONEY;
    public static final TagKey<Fluid> C_VISUAL_HONEY;
    public static final TagKey<Item> C_HONEY_BUCKETS;
    public static final TagKey<Fluid> C_MILK;
    public static final TagKey<Fluid> C_VISUAL_MILK;
    public static final TagKey<Fluid> C_FLUID_FUEL;

    public static void init() {
        DispenseItemBehavior dispenserBehavior = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.WATER_BUCKET);
        HONEY_BUCKET.listen(item -> DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)dispenserBehavior));
        BasicFluidHopperConfig.HANDLER.load();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static {
        C_HONEY = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"honey"));
        C_VISUAL_HONEY = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"visual/honey"));
        C_HONEY_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"buckets/honey"));
        C_MILK = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"milk"));
        C_VISUAL_MILK = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"visual/milk"));
        C_FLUID_FUEL = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"fuel"));
        HONEY_FLUID_ATTRIBUTES = SimpleArchitecturyFluidAttributes.ofSupplier(() -> HONEY_FLUID_FLOWING, () -> HONEY_FLUID).density(3000).viscosity(4000).dropOff(2).tickDelay(60).color(-855715481).emptySound(SoundEvents.BEEHIVE_DRIP).fillSound(SoundEvents.BEEHIVE_DRIP).sourceTexture(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"block/honey_still")).flowingTexture(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"block/honey_flow")).overlayTexture(ResourceLocation.withDefaultNamespace((String)"block/water_overlay")).blockSupplier(() -> HONEY_SOURCE_BLOCK).bucketItemSupplier(() -> HONEY_BUCKET);
        FLUIDS = MANAGER.get().get(Registries.FLUID);
        HONEY_FLUID = FLUIDS.register(BasicFluidHopper.id("honey"), () -> new ArchitecturyFlowingFluid.Source(HONEY_FLUID_ATTRIBUTES));
        HONEY_FLUID_FLOWING = FLUIDS.register(BasicFluidHopper.id("flowing_honey"), () -> new ArchitecturyFlowingFluid.Flowing(HONEY_FLUID_ATTRIBUTES));
        BLOCKS = MANAGER.get().get(Registries.BLOCK);
        BASIC_FLUID_HOPPER_BLOCK = BLOCKS.register(BasicFluidHopper.id(MOD_ID), () -> new BasicFluidHopperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HOPPER)));
        HONEY_SOURCE_BLOCK = BLOCKS.register(BasicFluidHopper.id("honey"), () -> new ArchitecturyLiquidBlock(HONEY_FLUID, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).speedFactor(0.2f).jumpFactor(0.3f).noLootTable().liquid().sound(SoundType.HONEY_BLOCK)));
        BLOCK_ENTITIES = MANAGER.get().get(Registries.BLOCK_ENTITY_TYPE);
        BASIC_FLUID_HOPPER_BLOCK_ENTITY = BLOCK_ENTITIES.register(BasicFluidHopper.id(MOD_ID), () -> BlockEntityType.Builder.of(BasicFluidHopperBlockEntity::new, (Block[])new Block[]{(Block)BASIC_FLUID_HOPPER_BLOCK.get()}).build(null));
        ENTITIES = MANAGER.get().get(Registries.ENTITY_TYPE);
        BASIC_FLUID_HOPPER_MINECART_ENTITY = ENTITIES.register(BasicFluidHopper.id("basic_fluid_hopper_minecart"), () -> EntityType.Builder.of(BasicFluidHopperMinecartEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.7f).build("basic_fluid_hopper_minecart"));
        ITEMS = MANAGER.get().get(Registries.ITEM);
        BASIC_FLUID_HOPPER_ITEM = ITEMS.register(BasicFluidHopper.id(MOD_ID), () -> new BlockItem((Block)BASIC_FLUID_HOPPER_BLOCK.get(), new Item.Properties()));
        BASIC_FLUID_HOPPER_MINECART_ITEM = ITEMS.register(BasicFluidHopper.id("basic_fluid_hopper_minecart"), () -> new BasicFluidHopperMinecartItem(new Item.Properties().stacksTo(1)));
        HONEY_BUCKET = ITEMS.register(BasicFluidHopper.id("honey_bucket"), () -> new ArchitecturyBucketItem(HONEY_FLUID, new Item.Properties().craftRemainder(Items.BUCKET)));
        MILK_BOTTLE = ITEMS.register(BasicFluidHopper.id("milk_bottle"), () -> new MilkBottleItem(new Item.Properties().stacksTo(16).craftRemainder(Items.GLASS_BOTTLE)));
    }
}

