/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.block;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.entity.BasicFluidHopperBlockEntity;
import com.jship.basicfluidhopper.block.neoforge.BasicFluidHopperBlockImpl;
import com.jship.basicfluidhopper.fluid.FluidHopper;
import com.mojang.serialization.MapCodec;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicFluidHopperBlock
extends BaseEntityBlock {
    public static final MapCodec<BasicFluidHopperBlock> CODEC = BasicFluidHopperBlock.simpleCodec(BasicFluidHopperBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING_HOPPER;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape OUTSIDE_SHAPE = Shapes.or((VoxelShape)MIDDLE_SHAPE, (VoxelShape)TOP_SHAPE);
    private static final VoxelShape INSIDE_SHAPE = BasicFluidHopperBlock.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape DEFAULT_SHAPE = Shapes.join((VoxelShape)OUTSIDE_SHAPE, (VoxelShape)INSIDE_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)DEFAULT_SHAPE, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)DEFAULT_SHAPE, (VoxelShape)Block.box((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)DEFAULT_SHAPE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)DEFAULT_SHAPE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)DEFAULT_SHAPE, (VoxelShape)Block.box((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYCAST_SHAPE = INSIDE_SHAPE;
    private static final VoxelShape EAST_RAYCAST_SHAPE = Shapes.or((VoxelShape)INSIDE_SHAPE, (VoxelShape)Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYCAST_SHAPE = Shapes.or((VoxelShape)INSIDE_SHAPE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYCAST_SHAPE = Shapes.or((VoxelShape)INSIDE_SHAPE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYCAST_SHAPE = Shapes.or((VoxelShape)INSIDE_SHAPE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public MapCodec<BasicFluidHopperBlock> codec() {
        return CODEC;
    }

    public BasicFluidHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return DEFAULT_SHAPE;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return DOWN_RAYCAST_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYCAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYCAST_SHAPE;
            }
            case WEST: {
                return WEST_RAYCAST_SHAPE;
            }
            case EAST: {
                return EAST_RAYCAST_SHAPE;
            }
        }
        return INSIDE_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.DOWN : direction))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BasicFluidHopperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BasicFluidHopperBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK_ENTITY.get()), BasicFluidHopperBlockEntity::pushFluidTick);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return FluidHopper.useFluidItem(level, player, hand, (FluidHopper)level.getBlockEntity(pos));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BasicFluidHopperBlockEntity hopperEntity;
        BlockEntity blockEntity;
        if (entity.getY() > (double)((float)pos.getY() + 0.3f) && (blockEntity = level.getBlockEntity(pos)) instanceof BasicFluidHopperBlockEntity && (hopperEntity = (BasicFluidHopperBlockEntity)blockEntity).getFluidStorage().getFluidInTank(0).getFluid().arch$holder().is(FluidTags.LAVA)) {
            entity.lavaHurt();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Fluid getMilk() {
        return BasicFluidHopperBlockImpl.getMilk();
    }

    private boolean isMilkable(Entity entity) {
        Animal animal;
        if (!(entity instanceof Animal) || (animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (entity instanceof Cow) {
            return true;
        }
        if (Platform.isModLoaded((String)"milkallthemobs")) {
            return entity instanceof Sheep || entity instanceof Llama || entity instanceof Pig || entity instanceof Donkey || entity instanceof Horse || entity instanceof Mule;
        }
        return false;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        BasicFluidHopperBlockEntity hopperEntity;
        long inserted;
        BlockEntity blockEntity;
        if (this.isMilkable(entity) && (blockEntity = level.getBlockEntity(pos)) instanceof BasicFluidHopperBlockEntity && (inserted = (hopperEntity = (BasicFluidHopperBlockEntity)blockEntity).getFluidStorage().fill(FluidStack.create((Fluid)BasicFluidHopperBlock.getMilk(), (long)FluidStack.bucketAmount()), true)) > 0L) {
            hopperEntity.getFluidStorage().fill(FluidStack.create((Fluid)BasicFluidHopperBlock.getMilk(), (long)FluidStack.bucketAmount()), false);
            level.playSound(null, pos, SoundEvents.COW_MILK, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            ((BasicFluidHopperBlockEntity)level.getBlockEntity(pos)).getFluidStorage().fill(FluidStack.create((Fluid)Fluids.WATER, (long)(FluidStack.bucketAmount() / (long)(Platform.isNeoForge() ? 100 : 81))), false);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        BlockPos dripstonePos = PointedDripstoneBlock.findStalactiteTipAboveCauldron((Level)level, (BlockPos)pos);
        if (dripstonePos == null) {
            return;
        }
        Fluid fluid = PointedDripstoneBlock.getCauldronFillFluidType((ServerLevel)level, (BlockPos)dripstonePos);
        if (fluid != Fluids.EMPTY && (blockEntity = level.getBlockEntity(pos)) instanceof BasicFluidHopperBlockEntity) {
            BasicFluidHopperBlockEntity hopperEntity = (BasicFluidHopperBlockEntity)blockEntity;
            hopperEntity.getFluidStorage().fill(FluidStack.create((Fluid)fluid, (long)(FluidStack.bucketAmount() / (long)(Platform.isNeoForge() ? 4 : 3))), false);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean bl;
        boolean bl2 = bl = !level.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, moved);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return ((BasicFluidHopperBlockEntity)level.getBlockEntity(pos)).getAnalogOutputSignal();
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

