/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.block.renderer;

import com.jship.basicfluidhopper.block.entity.BasicFluidHopperBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import lombok.Generated;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFluidHopperBlockEntityRenderer
implements BlockEntityRenderer<BasicFluidHopperBlockEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicFluidHopperBlockEntityRenderer.class);

    public BasicFluidHopperBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BasicFluidHopperBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockPos abovePos;
        Level level = blockEntity.getLevel();
        if (level.getBlockState(abovePos = blockEntity.getBlockPos().above()).isRedstoneConductor((BlockGetter)level, abovePos)) {
            return;
        }
        FluidStack fluidStack = blockEntity.getFluidStorage().getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        TextureAtlasSprite stillSprite = FluidStackHooks.getStillTexture((FluidStack)fluidStack);
        if (stillSprite == null) {
            return;
        }
        FluidState fluidState = fluidStack.getFluid().defaultFluidState();
        int tintColor = FluidStackHooks.getColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos(), (FluidState)fluidState) | 0xFF000000;
        if ((tintColor & 0xFF000000) < 0xF000000) {
            tintColor |= 0xCF000000;
        }
        float height = Math.min(1.0f, (float)fluidStack.getAmount() / (float)blockEntity.getFluidStorage().getTankCapacity(0)) * 0.3f + 0.688125f;
        VertexConsumer builder = buffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState));
        BasicFluidHopperBlockEntityRenderer.drawVertex(builder, poseStack, 0.125f, height, 0.125f, stillSprite.getU0(), stillSprite.getV0(), packedLight, packedOverlay, tintColor);
        BasicFluidHopperBlockEntityRenderer.drawVertex(builder, poseStack, 0.125f, height, 0.875f, stillSprite.getU0(), stillSprite.getV1(), packedLight, packedOverlay, tintColor);
        BasicFluidHopperBlockEntityRenderer.drawVertex(builder, poseStack, 0.875f, height, 0.875f, stillSprite.getU1(), stillSprite.getV1(), packedLight, packedOverlay, tintColor);
        BasicFluidHopperBlockEntityRenderer.drawVertex(builder, poseStack, 0.875f, height, 0.125f, stillSprite.getU1(), stillSprite.getV0(), packedLight, packedOverlay, tintColor);
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int packedOverlay, int tintColor) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setUv(u, v).setLight(packedLight).setColor(tintColor).setNormal(0.0f, 1.0f, 0.0f);
    }
}

