/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.fluid;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.spiritapi.api.fluid.SpiritFluidStorage;
import com.jship.spiritapi.api.fluid.SpiritFluidUtil;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

public interface FluidHopper {
    public void markDirty();

    public SpiritFluidStorage getFluidStorage();

    public void setTransferCooldown(int var1);

    public boolean needsCooldown();

    public boolean isEnabled();

    public Direction getFacing();

    public static boolean fillAndDrain(Level level, BlockPos pos, BlockState state, FluidHopper fluidHopper) {
        if (level.isClientSide) {
            return false;
        }
        if (!fluidHopper.needsCooldown() && fluidHopper.isEnabled() && (!fluidHopper.getFluidStorage().getFluidInTank(0).isEmpty() && FluidHopper.fill(level, pos, fluidHopper) || fluidHopper.getFluidStorage().getFluidInTank(0).getAmount() < fluidHopper.getFluidStorage().getTankCapacity(0) && FluidHopper.drain(level, pos, Direction.UP, fluidHopper))) {
            fluidHopper.setTransferCooldown(BasicFluidHopperConfig.transferCooldown());
            fluidHopper.markDirty();
            return true;
        }
        return false;
    }

    public static ItemInteractionResult useFluidItem(Level level, Player player, InteractionHand hand, FluidHopper fluidHopper) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack item = player.getItemInHand(hand);
        if (SpiritFluidUtil.isFluidItem((ItemStack)item)) {
            FluidStack playerFluid = SpiritFluidUtil.getFluidFromItem((ItemStack)item);
            FluidStack storageFluid = fluidHopper.getFluidStorage().getFluidInTank(0);
            if (playerFluid.isEmpty()) {
                if (SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)true)) {
                    SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)false);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (storageFluid.getAmount() < fluidHopper.getFluidStorage().getTankCapacity(0)) {
                if (SpiritFluidUtil.drainItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)true)) {
                    SpiritFluidUtil.drainItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)false);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (storageFluid.getAmount() >= fluidHopper.getFluidStorage().getTankCapacity(0) && SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)true)) {
                SpiritFluidUtil.fillItem((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Player)player, (InteractionHand)hand, (boolean)false);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean remove(FluidHopper fluidHopper, long amount) {
        if (fluidHopper.getFluidStorage().getFluidInTank(0).isEmpty()) {
            return false;
        }
        if (fluidHopper.getFluidStorage().drain(amount, true).getAmount() == amount) {
            fluidHopper.getFluidStorage().drain(amount, false);
            return true;
        }
        return false;
    }

    public static List<VehicleEntity> getVehicles(Level level, BlockPos pos) {
        return level.getEntities((Entity)null, new AABB((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)).stream().filter(entity -> entity instanceof VehicleEntity).map(entity -> (VehicleEntity)entity).toList();
    }

    private static boolean fill(Level level, BlockPos pos, FluidHopper fluidHopper) {
        long filled = SpiritFluidUtil.fillBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (BlockPos)pos.relative(fluidHopper.getFacing()), (Direction)fluidHopper.getFacing(), (boolean)true);
        if (filled > 0L) {
            SpiritFluidUtil.fillBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (BlockPos)pos.relative(fluidHopper.getFacing()), (Direction)fluidHopper.getFacing(), (boolean)false);
            return true;
        }
        for (VehicleEntity vehicle : FluidHopper.getVehicles(level, pos.relative(fluidHopper.getFacing()))) {
            filled = SpiritFluidUtil.fillVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (VehicleEntity)vehicle, (boolean)true);
            if (filled <= 0L) continue;
            SpiritFluidUtil.fillVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (VehicleEntity)vehicle, (boolean)false);
            return true;
        }
        return false;
    }

    public static boolean drain(Level level, BlockPos pos, Direction facing, FluidHopper fluidHopper) {
        Block bottleAmount2;
        int honey_level;
        long drained = SpiritFluidUtil.drainBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (BlockPos)pos.above(), (Direction)facing, (boolean)true);
        if (drained > 0L) {
            SpiritFluidUtil.drainBlockPos((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (BlockPos)pos.above(), (Direction)facing, (boolean)false);
            return true;
        }
        BlockState aboveState = level.getBlockState(pos.above());
        if (aboveState.getBlock() instanceof BeehiveBlock && (honey_level = BeehiveBlockEntity.getHoneyLevel((BlockState)aboveState)) > 0) {
            long bottleAmount2 = FluidStack.bucketAmount() / 4L;
            FluidStack honey = FluidStack.create((Fluid)((Fluid)BasicFluidHopper.HONEY_FLUID.get()), (long)bottleAmount2);
            long added = fluidHopper.getFluidStorage().fill(honey, true);
            if (added == bottleAmount2) {
                fluidHopper.getFluidStorage().fill(honey, false);
                level.setBlockAndUpdate(pos.above(), (BlockState)aboveState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(honey_level - 1)));
                return true;
            }
        }
        if ((bottleAmount2 = aboveState.getBlock()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)bottleAmount2;
            FluidState aboveFluidState = aboveState.getFluidState();
            if (aboveFluidState.isSource()) {
                ItemStack bucket;
                FluidStack fluid = FluidStack.create((Fluid)aboveFluidState.getType(), (long)FluidStack.bucketAmount());
                long inserted = fluidHopper.getFluidStorage().fill(fluid, true);
                if (inserted == FluidStack.bucketAmount() && !(bucket = bucketPickup.pickupBlock(null, (LevelAccessor)level, pos.above(), aboveState)).isEmpty()) {
                    fluidHopper.getFluidStorage().fill(fluid, false);
                    return true;
                }
            }
        }
        for (VehicleEntity vehicle : FluidHopper.getVehicles(level, pos.above())) {
            drained = SpiritFluidUtil.drainVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (VehicleEntity)vehicle, (boolean)true);
            if (drained <= 0L) continue;
            SpiritFluidUtil.drainVehicle((SpiritFluidStorage)fluidHopper.getFluidStorage(), (Level)level, (VehicleEntity)vehicle, (boolean)false);
            return true;
        }
        return false;
    }

    public static boolean tryFillBucket(ItemStack item, Level level, BlockPos pos, Player player, InteractionHand hand, SpiritFluidStorage fluidStorage) {
        FluidStack fluid = fluidStorage.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return false;
        }
        FluidStack removed = fluidStorage.drain(FluidStack.bucketAmount(), true);
        if (removed.getAmount() != FluidStack.bucketAmount()) {
            return false;
        }
        Item bucket = fluid.getFluid().getBucket();
        ItemStack emptyBucket = player.getItemInHand(hand);
        if (bucket != Items.AIR && emptyBucket.is(Items.BUCKET)) {
            ItemStack bucketStack = new ItemStack((ItemLike)bucket);
            bucketStack.applyComponents(emptyBucket.getComponents());
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)bucketStack));
            SoundEvent pickupSound = bucket == Items.LAVA_BUCKET ? SoundEvents.BUCKET_FILL_LAVA : (bucket == BasicFluidHopper.HONEY_BUCKET.get() ? SoundEvents.BEEHIVE_DRIP : SoundEvents.BUCKET_FILL);
            level.playSound(null, pos, pickupSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
            fluidStorage.drain(FluidStack.bucketAmount(), false);
            return true;
        }
        return false;
    }

    public static boolean tryDrainBucket(ItemStack item, Level level, BlockPos pos, Player player, InteractionHand hand, SpiritFluidStorage fluidStorage) {
        Item item2 = item.getItem();
        if (!(item2 instanceof BucketItem)) {
            return false;
        }
        BucketItem bucketItem = (BucketItem)item2;
        FluidStack fluid = FluidStack.create((Fluid)bucketItem.arch$getFluid(), (long)FluidStack.bucketAmount());
        if (fluid.isEmpty()) {
            return false;
        }
        long inserted = fluidStorage.fill(fluid, true);
        if (inserted != FluidStack.bucketAmount()) {
            return false;
        }
        SoundEvent bucketEmpty = item.is(Items.LAVA_BUCKET) ? SoundEvents.BUCKET_EMPTY_LAVA : (item.is((Item)BasicFluidHopper.HONEY_BUCKET.get()) ? SoundEvents.BEEHIVE_DRIP : SoundEvents.BUCKET_EMPTY);
        level.playSound(null, pos, bucketEmpty, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
        ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
        emptyBucket.applyComponents(bucketItem.components());
        player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)emptyBucket));
        fluidStorage.fill(FluidStack.create((FluidStack)fluid, (long)FluidStack.bucketAmount()), false);
        return true;
    }
}

