/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.util;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.block.entity.BasicFluidHopperBlockEntity;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class FluidHopperUtil {
    @Nullable
    public static BasicFluidHopperBlockEntity getHopperInsertingFluid(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity, boolean burnable, @Nullable ItemStack item) {
        if (level == null || level.isClientSide()) {
            return null;
        }
        for (Direction direction : Direction.allShuffled((RandomSource)level.getRandom())) {
            BucketItem bucket;
            Item item2;
            BasicFluidHopperBlockEntity ent;
            BlockEntity blockEntity2;
            if (level == null || level.isClientSide() || !((blockEntity2 = level.getBlockEntity(pos.relative(direction))) instanceof BasicFluidHopperBlockEntity) || (ent = (BasicFluidHopperBlockEntity)blockEntity2).getFacing() != direction.getOpposite() || ent.getFluidStorage().getFluidInTank(0).isEmpty()) continue;
            BasicFluidHopperBlockEntity hopperEntity = ent;
            FluidStack hopperFluid = hopperEntity.getFluidStorage().getFluidInTank(0);
            if (item == null && !hopperFluid.isEmpty() && burnable && hopperFluid.getFluid().is(BasicFluidHopper.C_FLUID_FUEL) && hopperFluid.getAmount() >= (long)(BasicFluidHopperConfig.fuelConsumeStep() * (float)FluidStack.bucketAmount())) {
                return hopperEntity;
            }
            if (item != null && item.is(Items.GLASS_BOTTLE) && hopperFluid.getAmount() >= FluidStack.bucketAmount() / 4L && (hopperFluid.getFluid().isSame((Fluid)Fluids.WATER) || hopperFluid.getFluid().is(BasicFluidHopper.C_MILK) || hopperFluid.getFluid().is(BasicFluidHopper.C_HONEY))) {
                return hopperEntity;
            }
            if (item == null || !((item2 = item.getItem()) instanceof BucketItem) || (bucket = (BucketItem)item2).arch$getFluid() != Fluids.EMPTY || hopperFluid.getFluid().getBucket() == null || hopperFluid.getAmount() < FluidStack.bucketAmount()) continue;
            return hopperEntity;
        }
        return null;
    }

    public static ItemStack fillDispenserItemFromHopper(ItemStack emptyItem, BlockSource dispenser) {
        BucketItem bucket;
        Item bottleAmount2;
        ServerLevel level = dispenser.level();
        BlockPos pos = dispenser.pos();
        if (emptyItem.is(Items.GLASS_BOTTLE)) {
            BasicFluidHopperBlockEntity fluidHopper = FluidHopperUtil.getHopperInsertingFluid((Level)level, pos, level.getBlockState(pos), level.getBlockEntity(pos), false, emptyItem);
            if (fluidHopper == null) {
                return new ItemStack((ItemLike)Items.AIR);
            }
            long bottleAmount2 = FluidStack.bucketAmount() / 4L;
            if (fluidHopper.getFluidStorage().getFluidInTank(0).getFluid().isSame((Fluid)Fluids.WATER) && fluidHopper.getFluidStorage().drain(bottleAmount2, true).getAmount() == bottleAmount2) {
                fluidHopper.getFluidStorage().drain(bottleAmount2, false);
                return PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
            }
            if (fluidHopper.getFluidStorage().getFluidInTank(0).getFluid().is(BasicFluidHopper.C_MILK) && fluidHopper.getFluidStorage().drain(bottleAmount2, true).getAmount() == bottleAmount2) {
                fluidHopper.getFluidStorage().drain(bottleAmount2, false);
                return new ItemStack((ItemLike)BasicFluidHopper.MILK_BOTTLE.get());
            }
            if (fluidHopper.getFluidStorage().getFluidInTank(0).getFluid().is(BasicFluidHopper.C_HONEY) && fluidHopper.getFluidStorage().drain(bottleAmount2, true).getAmount() == bottleAmount2) {
                fluidHopper.getFluidStorage().drain(bottleAmount2, false);
                return new ItemStack((ItemLike)Items.HONEY_BOTTLE);
            }
        }
        if ((bottleAmount2 = emptyItem.getItem()) instanceof BucketItem && (bucket = (BucketItem)bottleAmount2).arch$getFluid() == Fluids.EMPTY) {
            BasicFluidHopperBlockEntity fluidHopper = FluidHopperUtil.getHopperInsertingFluid((Level)level, pos, level.getBlockState(pos), level.getBlockEntity(pos), false, emptyItem);
            if (fluidHopper == null) {
                return new ItemStack((ItemLike)Items.AIR);
            }
            Item bucketItem = fluidHopper.getFluidStorage().getFluidInTank(0).getFluid().getBucket();
            if (bucketItem != Items.AIR && fluidHopper.getFluidStorage().drain(FluidStack.bucketAmount(), true).getAmount() == FluidStack.bucketAmount()) {
                fluidHopper.getFluidStorage().drain(FluidStack.bucketAmount(), false);
                return new ItemStack((ItemLike)bucketItem);
            }
        }
        return new ItemStack((ItemLike)Items.AIR);
    }
}

