/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.fluid.neoforge;

import com.jship.basicfluidhopper.BasicFluidHopper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class BottleFluidHandler
implements IFluidHandlerItem {
    protected ItemStack container;
    protected final ItemStack emptyContainer = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    protected final ItemStack waterContainer = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
    protected final ItemStack milkContainer = new ItemStack((ItemLike)BasicFluidHopper.MILK_BOTTLE.get());
    protected final ItemStack honeyContainer = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
    protected final int capacity = 250;

    public BottleFluidHandler(ItemStack container) {
        this.container = container;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        if (this.container.is(Items.POTION) && ((PotionContents)this.container.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            return new FluidStack((Fluid)Fluids.WATER, 250);
        }
        if (this.container.is((Item)BasicFluidHopper.MILK_BOTTLE.get())) {
            return new FluidStack((Fluid)NeoForgeMod.MILK.value(), 250);
        }
        if (this.container.is(Items.HONEY_BOTTLE)) {
            return new FluidStack((Fluid)BasicFluidHopper.HONEY_FLUID.get(), 250);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.getAmount() >= 250 && (stack.is((FluidType)NeoForgeMod.WATER_TYPE.value()) || stack.is((FluidType)NeoForgeMod.MILK_TYPE.value()) || stack.is(Tags.Fluids.HONEY));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || !this.isFluidValid(0, resource) || !this.container.is(Items.GLASS_BOTTLE)) {
            return 0;
        }
        if (action.execute()) {
            if (resource.is((FluidType)NeoForgeMod.WATER_TYPE.value())) {
                this.container = this.waterContainer.copy();
            } else if (resource.is((FluidType)NeoForgeMod.MILK_TYPE.value())) {
                this.container = this.milkContainer.copy();
            } else if (resource.is(Tags.Fluids.HONEY)) {
                this.container = this.honeyContainer.copy();
            } else {
                return 0;
            }
        }
        return 250;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || this.container.is(Items.GLASS_BOTTLE)) {
            return FluidStack.EMPTY;
        }
        if (this.getFluidInTank(0).is((FluidType)NeoForgeMod.WATER_TYPE.value()) && resource.is((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            return this.drain(250, action);
        }
        if (this.getFluidInTank(0).is((FluidType)NeoForgeMod.MILK_TYPE.value()) && resource.is((FluidType)NeoForgeMod.MILK_TYPE.value())) {
            return this.drain(250, action);
        }
        if (this.getFluidInTank(0).is(Tags.Fluids.HONEY) && resource.is(Tags.Fluids.HONEY)) {
            return this.drain(250, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || this.container.is(Items.GLASS_BOTTLE) || maxDrain < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = this.getFluidInTank(0).is((FluidType)NeoForgeMod.WATER_TYPE.value()) ? new FluidStack((Fluid)Fluids.WATER, 250) : (this.getFluidInTank(0).is((FluidType)NeoForgeMod.MILK_TYPE.value()) ? new FluidStack((Fluid)NeoForgeMod.MILK.value(), 250) : (this.getFluidInTank(0).is(Tags.Fluids.HONEY) ? new FluidStack((Fluid)BasicFluidHopper.HONEY_FLUID.get(), 250) : FluidStack.EMPTY));
        if (!drained.isEmpty() && action.execute()) {
            this.container = this.emptyContainer.copy();
        }
        return drained;
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

