/*
 * Decompiled with CFR 0.152.
 */
package com.jship.basicfluidhopper.vehicle;

import com.jship.basicfluidhopper.BasicFluidHopper;
import com.jship.basicfluidhopper.config.BasicFluidHopperConfig;
import com.jship.basicfluidhopper.fluid.FluidHopper;
import com.jship.spiritapi.api.fluid.SpiritFluidStorage;
import com.jship.spiritapi.api.fluid.SpiritFluidStorageProvider;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BasicFluidHopperMinecartEntity
extends AbstractMinecartContainer
implements FluidHopper,
SpiritFluidStorageProvider {
    private boolean enabled = true;
    private int transferCooldown = -1;
    public final SpiritFluidStorage fluidStorage = SpiritFluidStorage.create((long)((long)BasicFluidHopperConfig.hopperCapacity() * FluidStack.bucketAmount()), (long)((long)((float)FluidStack.bucketAmount() * BasicFluidHopperConfig.transferRate())), () -> this.markDirty());
    public static final EntityDataAccessor<CompoundTag> DATA_ID_FLUID = SynchedEntityData.defineId(BasicFluidHopperMinecartEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    public BasicFluidHopperMinecartEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public static BasicFluidHopperMinecartEntity create(ServerLevel level, double x, double y, double z) {
        BasicFluidHopperMinecartEntity basicFluidHopperMinecartEntity = new BasicFluidHopperMinecartEntity((EntityType)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ENTITY.get(), (Level)level);
        return basicFluidHopperMinecartEntity;
    }

    public SpiritFluidStorage getFluidStorage(Direction face) {
        return face == Direction.DOWN ? this.fluidStorage : null;
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((Block)BasicFluidHopper.BASIC_FLUID_HOPPER_BLOCK.get()).defaultBlockState();
    }

    public int getDefaultDisplayOffset() {
        return 1;
    }

    public void activateMinecart(int x, int y, int z, boolean powered) {
        boolean bl;
        boolean bl2 = bl = !powered;
        if (bl != this.isEnabled()) {
            this.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && this.isEnabled() && this.canOperate()) {
            this.markDirty();
        }
    }

    public boolean canOperate() {
        return FluidHopper.drain(this.level(), this.getOnPos(), Direction.UP, this);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return FluidHopper.useFluidItem(this.level(), player, hand, this);
    }

    public FluidStack getFluidStack() {
        CompoundTag fluidTag = (CompoundTag)this.getEntityData().get(DATA_ID_FLUID);
        if (fluidTag.isEmpty()) {
            return FluidStack.empty();
        }
        return FluidStackHooks.read((HolderLookup.Provider)this.registryAccess(), (Tag)fluidTag).orElse(FluidStack.empty());
    }

    @Override
    public void markDirty() {
        CompoundTag nbt = new CompoundTag();
        if (!this.fluidStorage.getFluidInTank(0).isEmpty()) {
            nbt.merge((CompoundTag)FluidStackHooks.write((HolderLookup.Provider)this.registryAccess(), (FluidStack)this.fluidStorage.getFluidInTank(0), (Tag)nbt));
        }
        this.entityData.set(DATA_ID_FLUID, (Object)nbt);
    }

    protected Item getDropItem() {
        return (Item)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ITEM.get();
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)BasicFluidHopper.BASIC_FLUID_HOPPER_MINECART_ITEM.get());
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("enabled", this.enabled);
        CompoundTag fluidNbt = this.fluidStorage.serializeNbt((HolderLookup.Provider)this.registryAccess());
        nbt.merge(fluidNbt);
        nbt.put("JadeFluidStorage", (Tag)fluidNbt);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.enabled = nbt.contains("enabled") ? nbt.getBoolean("enabled").orElse(true) : true;
        this.fluidStorage.deserializeNbt((HolderLookup.Provider)this.registryAccess(), nbt);
        this.entityData.set(DATA_ID_FLUID, (Object)nbt.getCompound("Fluid").orElse(new CompoundTag()));
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_FLUID, (Object)new CompoundTag());
    }

    @Override
    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    @Override
    public boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public Direction getFacing() {
        return Direction.DOWN;
    }

    @Override
    public SpiritFluidStorage getFluidStorage() {
        return this.fluidStorage;
    }

    public int getContainerSize() {
        throw new UnsupportedOperationException("Unimplemented method 'getContainerSize'");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        throw new UnsupportedOperationException("Unimplemented method 'createMenu'");
    }
}

