/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.envfogdisable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/environmentalfogdisable.json");
    private boolean fogEnabled = false;

    public ConfigManager() {
        this.load();
    }

    public boolean isFogEnabled() {
        return this.fogEnabled;
    }

    public void setFogEnabled(boolean enabled) {
        this.fogEnabled = enabled;
        this.save();
    }

    public void toggle() {
        this.setFogEnabled(!this.fogEnabled);
    }

    private void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null) {
                this.fogEnabled = config.fogEnabled;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Config config = new Config();
            config.fogEnabled = this.fogEnabled;
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class Config {
        public boolean fogEnabled = false;

        private Config() {
        }
    }
}

