/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.config;

import com.vanillapings.VanillaPings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class FileConfig {
    public static final String CONFIG_FOLDER = Paths.get(System.getProperty("user.dir"), "config/" + "VanillaPings".toLowerCase()).toString();
    private final String filePath;
    private final File file;
    private final Properties properties = new Properties();
    private final boolean printErrors;

    public FileConfig(String filePath) {
        this(filePath, true);
    }

    public FileConfig(String filePath, boolean printErrors) {
        this.printErrors = printErrors;
        this.file = new File(filePath);
        File parent = this.file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs() && printErrors) {
            VanillaPings.LOGGER.warn("Couldn't create dir: " + String.valueOf(parent));
        }
        this.filePath = filePath;
        this.loadConfig();
    }

    public void put(String key, Object value) {
        this.properties.put(key, value.toString());
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Nullable
    public Object get(String key) {
        return this.properties.get(key);
    }

    @Nullable
    public String getString(String key) {
        return (String)this.properties.get(key);
    }

    public int getInteger(String key) {
        try {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public float getFloat(String key) {
        try {
            return Float.parseFloat(this.properties.getProperty(key));
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
    }

    public double getDouble(String key) {
        try {
            return Double.parseDouble(this.properties.getProperty(key));
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public void clear() {
        this.properties.clear();
    }

    public void loadConfig() {
        block2: {
            try {
                FileInputStream inputStream = new FileInputStream(this.file);
                this.properties.load(inputStream);
            }
            catch (IOException ex) {
                if (!this.printErrors) break block2;
                VanillaPings.LOGGER.warn("Couldn't load " + this.filePath);
            }
        }
    }

    public void saveConfig() {
        block2: {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.file);
                this.properties.store(outputStream, this.file.getName());
            }
            catch (IOException ex) {
                if (!this.printErrors) break block2;
                VanillaPings.LOGGER.error("Couldn't write to " + String.valueOf(this.file));
            }
        }
    }

    public void deleteConfig() {
        block3: {
            this.clear();
            try {
                if (!this.file.delete() && this.printErrors) {
                    VanillaPings.LOGGER.error("Couldn't delete config" + String.valueOf(this.file));
                }
            }
            catch (SecurityException ex) {
                if (!this.printErrors) break block3;
                VanillaPings.LOGGER.error("Couldn't delete config " + String.valueOf(this.file));
            }
        }
    }
}

