/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.config;

import com.vanillapings.config.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PingSettings
extends Settings {
    private static final String KEY_DEFAULT_LANGUAGE = "lang";
    private static final String KEY_PING_RANGE = "ping-max-range";
    private static final String KEY_PING_CHAT_MESSAGE_RANGE = "ping-chat-message-range";
    private static final String KEY_PING_DIRECTION_MESSAGE_RANGE = "ping-direction-message-range";
    private static final String KEY_PING_COOLDOWN = "ping-cooldown";
    private static final String KEY_PING_ITEM_COUNT = "ping-item-count";
    private static final String KEY_PING_ITEM_COUNT_RANGE = "ping-item-count-range";
    private static final String KEY_PING_REMOVE_OLD_PINGS = "ping-remove-old";
    private static final String KEY_PING_GLOWING = "ping-glowing";
    private static final String KEY_PING_GLOWING_FLASH = "ping-glowing-flash";
    private static final String KEY_PING_ITEM = "ping-item";
    private static final String KEY_PING_PLAY_SOUND = "ping-sound";
    private final List<SettingsEvent> settingEvents = new ArrayList<SettingsEvent>();
    private String defaultLanguage = "en_us";
    private double pingRange = 500.0;
    private double pingChatMessageRange = 160.0;
    private double pingDirectionMessageRange = 160.0;
    private int pingCooldown = 5;
    private boolean pingItemCount = true;
    private boolean playSound = true;
    private double pingItemCountRange = 1.0;
    private boolean pingRemoveOld = true;
    private boolean pingGlowing = true;
    private boolean pingGlowingFlash = true;
    private class_1792 pingItem = class_1802.field_8126;

    public boolean registerSettingsEvent(SettingsEvent event) {
        return this.settingEvents.add(event);
    }

    public boolean unregisterSettingsEvent(SettingsEvent event) {
        return this.settingEvents.remove(event);
    }

    @Override
    protected void saveSettings() {
        this.cfg.put(KEY_DEFAULT_LANGUAGE, this.defaultLanguage);
        this.cfg.put(KEY_PING_RANGE, this.pingRange);
        this.cfg.put(KEY_PING_CHAT_MESSAGE_RANGE, this.pingChatMessageRange);
        this.cfg.put(KEY_PING_DIRECTION_MESSAGE_RANGE, this.pingDirectionMessageRange);
        this.cfg.put(KEY_PING_COOLDOWN, this.pingCooldown);
        this.cfg.put(KEY_PING_ITEM_COUNT, this.pingItemCount);
        this.cfg.put(KEY_PING_ITEM_COUNT_RANGE, this.pingItemCountRange);
        this.cfg.put(KEY_PING_REMOVE_OLD_PINGS, this.pingRemoveOld);
        this.cfg.put(KEY_PING_GLOWING, this.pingGlowing);
        this.cfg.put(KEY_PING_GLOWING_FLASH, this.pingGlowingFlash);
        this.cfg.put(KEY_PING_ITEM, class_7923.field_41178.method_10221((Object)this.pingItem).toString());
        this.cfg.put(KEY_PING_PLAY_SOUND, this.playSound);
        super.saveSettings();
    }

    @Override
    protected void loadSettings() {
        super.loadSettings();
        if (this.cfg.containsKey(KEY_DEFAULT_LANGUAGE)) {
            this.defaultLanguage = this.cfg.getString(KEY_DEFAULT_LANGUAGE);
        }
        if (this.cfg.containsKey(KEY_PING_RANGE)) {
            this.pingRange = this.cfg.getDouble(KEY_PING_RANGE);
        }
        if (this.cfg.containsKey(KEY_PING_CHAT_MESSAGE_RANGE)) {
            this.pingChatMessageRange = this.cfg.getDouble(KEY_PING_CHAT_MESSAGE_RANGE);
        }
        if (this.cfg.containsKey(KEY_PING_DIRECTION_MESSAGE_RANGE)) {
            this.pingDirectionMessageRange = this.cfg.getDouble(KEY_PING_DIRECTION_MESSAGE_RANGE);
        }
        if (this.cfg.containsKey(KEY_PING_COOLDOWN)) {
            this.pingCooldown = this.cfg.getInteger(KEY_PING_COOLDOWN);
        }
        if (this.cfg.containsKey(KEY_PING_ITEM_COUNT)) {
            this.pingItemCount = this.cfg.getBoolean(KEY_PING_ITEM_COUNT);
        }
        if (this.cfg.containsKey(KEY_PING_ITEM_COUNT_RANGE)) {
            this.pingItemCountRange = this.cfg.getDouble(KEY_PING_ITEM_COUNT_RANGE);
        }
        if (this.cfg.containsKey(KEY_PING_REMOVE_OLD_PINGS)) {
            this.pingRemoveOld = this.cfg.getBoolean(KEY_PING_REMOVE_OLD_PINGS);
        }
        if (this.cfg.containsKey(KEY_PING_GLOWING)) {
            this.pingGlowing = this.cfg.getBoolean(KEY_PING_GLOWING);
        }
        if (this.cfg.containsKey(KEY_PING_GLOWING_FLASH)) {
            this.pingGlowingFlash = this.cfg.getBoolean(KEY_PING_GLOWING_FLASH);
        }
        if (this.cfg.containsKey(KEY_PING_PLAY_SOUND)) {
            this.playSound = this.cfg.getBoolean(KEY_PING_PLAY_SOUND);
        }
        if (this.cfg.containsKey(KEY_PING_ITEM)) {
            String itemIdentifier = Objects.requireNonNull(this.cfg.getString(KEY_PING_ITEM));
            class_2960 pingItemIdentifier = class_2960.method_60654((String)itemIdentifier);
            this.pingItem = !class_7923.field_41178.method_10250(pingItemIdentifier) ? class_1802.field_8126 : (class_1792)class_7923.field_41178.method_63535(pingItemIdentifier);
        }
        if (this.pingItemCountRange < 0.0) {
            this.pingItemCountRange = 0.0;
        }
        if (this.pingRange < 0.0 && this.pingRange != -1.0) {
            this.pingRange = 0.0;
        }
        if (this.pingChatMessageRange < 0.0 && this.pingChatMessageRange != -1.0) {
            this.pingChatMessageRange = 0.0;
        }
        if (this.pingDirectionMessageRange < 0.0 && this.pingDirectionMessageRange != -1.0) {
            this.pingDirectionMessageRange = 0.0;
        }
        this.invokeSettingsRefreshed();
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public double getPingRange() {
        return this.pingRange == -1.0 ? 5000.0 : this.pingRange;
    }

    public double getPingChatMessageRange() {
        return this.pingChatMessageRange;
    }

    public boolean hasInfinitePingChatMessageRange() {
        return this.pingChatMessageRange == -1.0;
    }

    public double getPingDirectionMessageRange() {
        return this.pingDirectionMessageRange;
    }

    public boolean hasInfinitePingDirectionMessageRange() {
        return this.pingDirectionMessageRange == -1.0;
    }

    public int getPingCooldown() {
        return this.pingCooldown;
    }

    public boolean setLangauge(String language) {
        if (language.equals(this.defaultLanguage)) {
            return false;
        }
        this.defaultLanguage = language;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPlaySound(boolean playSound) {
        if (playSound == this.playSound) {
            return false;
        }
        this.playSound = playSound;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setGlowing(boolean glowing) {
        if (glowing == this.pingGlowing) {
            return false;
        }
        this.pingGlowing = glowing;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingItem(class_1792 item) {
        if (item == this.pingItem) {
            return false;
        }
        this.pingItem = item;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setGlowingFlash(boolean glowingFlash) {
        if (glowingFlash == this.pingGlowingFlash) {
            return false;
        }
        this.pingGlowingFlash = glowingFlash;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setItemCountRange(double range) {
        if (range == this.pingItemCountRange) {
            return false;
        }
        this.pingItemCountRange = range;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingRange(double range) {
        if (range == this.pingRange) {
            return false;
        }
        this.pingRange = range;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingChatMessageRange(double range) {
        if (range == this.pingChatMessageRange) {
            return false;
        }
        this.pingChatMessageRange = range;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingDirectionMessageRange(double range) {
        if (range == this.pingDirectionMessageRange) {
            return false;
        }
        this.pingDirectionMessageRange = range;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingCooldown(int ticks) {
        if (ticks == this.pingCooldown) {
            return false;
        }
        this.pingCooldown = ticks;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean setPingItemCount(boolean pingItemCount) {
        if (pingItemCount == this.pingItemCount) {
            return false;
        }
        this.pingItemCount = pingItemCount;
        this.saveSettings();
        this.invokeSettingsRefreshed();
        return true;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public boolean isPingItemCount() {
        return this.pingItemCount;
    }

    public double getPingItemCountRange() {
        return this.pingItemCountRange;
    }

    public boolean isPingRemoveOld() {
        return this.pingRemoveOld;
    }

    public boolean isPingGlowing() {
        return this.pingGlowing;
    }

    public boolean isPingGlowingFlash() {
        return this.pingGlowingFlash;
    }

    public class_1792 getPingItem() {
        return this.pingItem;
    }

    private void invokeSettingsRefreshed() {
        this.settingEvents.forEach(SettingsEvent::refresh);
    }

    @FunctionalInterface
    public static interface SettingsEvent {
        public void refresh();
    }
}

