/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.features.ping;

import net.minecraft.class_1297;

public class HighlightSettings {
    private final boolean highlight;
    private final boolean flash;
    private int flashRate;
    private float startFlashing;
    private int flashCycle = 0;
    private boolean isActive = true;
    private boolean speedUp = false;

    public HighlightSettings(boolean highlight, boolean flash, int flashRate, float startFlashing) {
        this.highlight = highlight;
        this.flash = flash;
        this.flashRate = flashRate;
        this.startFlashing = startFlashing;
    }

    public HighlightSettings(int flashRate, float startFlashing) {
        this.highlight = true;
        this.flash = true;
        this.flashRate = flashRate;
        this.startFlashing = startFlashing;
    }

    public HighlightSettings(boolean highlight) {
        this.highlight = highlight;
        this.flash = false;
    }

    public void animate(int age, int maxAge, class_1297 entity) {
        if (!this.flash) {
            return;
        }
        float flashFactor = (float)age / (float)maxAge;
        if (flashFactor < this.startFlashing) {
            return;
        }
        if ((double)flashFactor > 0.9 && !this.speedUp) {
            this.speedUp = true;
            this.flashRate /= 2;
        }
        if (this.flashCycle >= this.flashRate) {
            this.flashCycle = 0;
            this.isActive = !this.isActive;
            entity.method_5834(this.isActive);
        }
        ++this.flashCycle;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public boolean isFlash() {
        return this.flash;
    }

    public int getFlashRate() {
        return this.flashRate;
    }
}

