/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.features.ping;

import com.vanillapings.VanillaPings;
import com.vanillapings.features.ping.HighlightSettings;
import com.vanillapings.features.ping.PingedEntity;
import com.vanillapings.mixin.ArmorStandEntityAccessor;
import com.vanillapings.translation.Translations;
import com.vanillapings.util.InputCooldown;
import com.vanillapings.util.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PingManager {
    private static final List<PingedEntity> entities = new ArrayList<PingedEntity>();
    private static final class_2583 noPingStyle = class_2561.method_43473().method_10866().method_10977(class_124.field_1075);
    private static final class_2561 noPingText = class_2561.method_43470((String)"_noping").method_10862(noPingStyle);
    private static final Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private static final InputCooldown clearOldPingCooldown = new InputCooldown(400);

    public static void pingWithCooldown(class_1657 player) {
        if (playerCooldowns.containsKey(player.method_5667())) {
            return;
        }
        playerCooldowns.put(player.method_5667(), VanillaPings.SETTINGS.getPingCooldown());
        PingManager.pingInFrontOfEntity(player, null);
    }

    public static void pingInFrontOfEntity(class_1657 player, @Nullable CustomPingHandle customHandle) {
        class_243 specificPos;
        boolean isNotInWater = player.method_55667().method_26227().method_15769();
        @Nullable class_1297 targetEntity = null;
        @Nullable class_243 pos = PingManager.fastRaycast((class_1297)player, isNotInWater, VanillaPings.SETTINGS.getPingRange());
        if (pos != null && pos.method_1022(player.method_73189()) < 200.0 && (specificPos = PingManager.exactRaycast((class_1297)player, isNotInWater, pos.method_1022(player.method_73189()) + 25.0)) != null) {
            pos = specificPos;
        }
        @Nullable RayResult result = PingManager.fastEntityRaycast((class_1297)player, VanillaPings.SETTINGS.getPingRange());
        if (pos == null && result != null) {
            targetEntity = result.entity;
            pos = result.position;
        } else if (pos != null && result != null) {
            if (result.position.method_1022(player.method_73189()) < pos.method_1022(player.method_73189())) {
                pos = result.position;
                targetEntity = result.entity;
            }
        } else if (pos == null) {
            return;
        }
        if (customHandle != null) {
            customHandle.ping(pos, targetEntity, player, player.method_73183());
            return;
        }
        PingManager.pingAtPosition(pos, targetEntity, player, player.method_73183());
    }

    public static void pingAtPosition(class_243 pos, @Nullable class_1297 pingEntity, class_1657 player, class_1937 world) {
        class_1297 targetEntity;
        boolean animate = true;
        boolean kill = true;
        HighlightSettings highlight = new HighlightSettings(VanillaPings.SETTINGS.isPingGlowing(), VanillaPings.SETTINGS.isPingGlowingFlash(), 5, 0.65f);
        if (pingEntity != null) {
            animate = false;
            kill = false;
            targetEntity = pingEntity;
        } else {
            class_1531 entity = (class_1531)class_1299.field_6131.method_5899((class_3218)world, armorStand -> {
                ArmorStandEntityAccessor accessor = (ArmorStandEntityAccessor)armorStand;
                accessor.invokeSetMarker(true);
                accessor.invokeSetSmall(true);
                armorStand.method_5648(true);
                armorStand.method_5875(true);
                armorStand.method_5684(true);
                armorStand.method_6907(true);
                armorStand.method_6913(false);
                armorStand.method_5665(noPingText);
                armorStand.method_5673(class_1304.field_6169, new class_1799((class_1935)VanillaPings.SETTINGS.getPingItem()));
                armorStand.method_23327(pos.method_10216(), pos.method_10214() - 0.8, pos.method_10215());
            }, class_2338.method_49638((class_2374)pos), class_3730.field_16462, false, false);
            if (entity == null) {
                VanillaPings.LOGGER.error("Couldn't spawn armor stand for ping. This is not intended behaviour.");
                return;
            }
            targetEntity = entity;
        }
        world.method_18456().forEach(playerEntity -> {
            class_243 playerPos = playerEntity.method_73189();
            int distance = (int)Math.floor(new class_243(pos.field_1352 - playerPos.field_1352, 0.0, pos.field_1350 - playerPos.field_1350).method_1033());
            if ((double)distance < VanillaPings.SETTINGS.getPingDirectionMessageRange() || VanillaPings.SETTINGS.hasInfinitePingDirectionMessageRange()) {
                double degree = PingManager.getDegreeDirectionToPing(pos, playerEntity.method_73189());
                double relDegree = PingManager.getRelativeDegree(degree, playerEntity.method_36454());
                class_5250 pingDirMessage = Translations.PING_DIRECTION_MESSAGE.constructMessage(new Triple<Integer, String, String>(distance, PingManager.getPingDirectionArrow(relDegree), PingManager.getPingCardinalDirection(degree)));
                playerEntity.method_7353((class_2561)pingDirMessage, true);
            }
            if (pingEntity != null && ((double)distance < VanillaPings.SETTINGS.getPingChatMessageRange() || VanillaPings.SETTINGS.hasInfinitePingChatMessageRange())) {
                class_5250 pingMessage = Translations.PING_MESSAGE.constructMessage(new Triple<String, class_2561, class_2382>(player.method_5477().getString(), PingManager.getTextForEntity(pingEntity), new class_2382((int)Math.round(pos.field_1352), (int)Math.round(pos.field_1351), (int)Math.round(pos.field_1350))));
                playerEntity.method_7353((class_2561)pingMessage, false);
            }
        });
        PingedEntity pingedEntity = new PingedEntity(targetEntity, 100, animate, kill, VanillaPings.SETTINGS.isPlaySound(), highlight);
        entities.add(pingedEntity);
        pingedEntity.tick();
    }

    public static double getRelativeDegree(double degree, double playerYaw) {
        double relDegree;
        if (playerYaw < 0.0) {
            playerYaw += 360.0;
        }
        if ((relDegree = degree + (playerYaw = 270.0 - playerYaw)) > 360.0) {
            relDegree -= 360.0;
        }
        return relDegree;
    }

    public static double getDegreeDirectionToPing(class_243 pingLocation, class_243 playerLocation) {
        double ak = pingLocation.field_1352 - playerLocation.field_1352;
        double gk = pingLocation.field_1350 - playerLocation.field_1350;
        double hy = new class_243(ak, 0.0, pingLocation.field_1350 - playerLocation.field_1350).method_1033();
        double degree = Math.acos(ak / hy) * 57.29577951308232;
        if (gk < 0.0) {
            degree = 360.0 - degree;
        }
        return degree;
    }

    public static String getPingDirectionArrow(double degree) {
        if (degree >= 22.5 && degree <= 67.5) {
            return "\ud83e\udc7d";
        }
        if (degree >= 67.5 && degree <= 112.5) {
            return "\ud83e\udc7a";
        }
        if (degree >= 112.5 && degree <= 157.5) {
            return "\ud83e\udc7e";
        }
        if (degree >= 157.5 && degree <= 202.5) {
            return "\ud83e\udc7b";
        }
        if (degree >= 202.5 && degree <= 247.5) {
            return "\ud83e\udc7f";
        }
        if (degree >= 247.5 && degree <= 292.5) {
            return "\ud83e\udc78";
        }
        if (degree >= 292.5 && degree <= 337.5) {
            return "\ud83e\udc7c";
        }
        return "\ud83e\udc79";
    }

    public static String getPingCardinalDirection(double degree) {
        if (degree >= 22.5 && degree <= 67.5) {
            return "SE";
        }
        if (degree >= 67.5 && degree <= 112.5) {
            return "S";
        }
        if (degree >= 112.5 && degree <= 157.5) {
            return "SW";
        }
        if (degree >= 157.5 && degree <= 202.5) {
            return "W";
        }
        if (degree >= 202.5 && degree <= 247.5) {
            return "NW";
        }
        if (degree >= 247.5 && degree <= 292.5) {
            return "N";
        }
        if (degree >= 292.5 && degree <= 337.5) {
            return "NE";
        }
        return "E";
    }

    public static class_2561 getTextForEntity(class_1297 entity) {
        if (entity instanceof class_1542) {
            int amount;
            class_1542 itemEntity = (class_1542)entity;
            class_5250 completeText = (class_5250)itemEntity.method_6983().method_7954();
            if (VanillaPings.SETTINGS.isPingItemCount() && VanillaPings.SETTINGS.getPingItemCountRange() != 0.0 && (amount = PingManager.countStackableItemsInRange(itemEntity.method_73183(), itemEntity.method_73189(), VanillaPings.SETTINGS.getPingItemCountRange(), itemEntity.method_6983())) > 1) {
                class_5250 amountText = (class_5250)class_2561.method_30163((String)String.format(" (%dx)", amount));
                completeText.method_10852((class_2561)amountText);
            }
            return completeText;
        }
        class_5250 completeText = class_2561.method_43473().method_27692(class_124.field_1067);
        class_2583 nameStyle = completeText.method_10866().method_10977(class_124.field_1078);
        if (entity instanceof class_1588) {
            nameStyle = completeText.method_10866().method_10977(class_124.field_1054);
        } else if (entity instanceof class_1309) {
            nameStyle = completeText.method_10866().method_10977(class_124.field_1077);
        }
        class_5250 nameText = class_2561.method_43470((String)entity.method_5477().getString());
        nameText.method_10862(nameStyle);
        completeText.method_10852((class_2561)nameText);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_2583 healthStyle = completeText.method_10866().method_10977(class_124.field_1060);
            int health = Math.round(livingEntity.method_6032());
            float perc = livingEntity.method_6032() / livingEntity.method_6063();
            if ((double)perc < 0.8) {
                healthStyle = completeText.method_10866().method_10977(class_124.field_1077);
            }
            if ((double)perc < 0.6) {
                healthStyle = completeText.method_10866().method_10977(class_124.field_1054);
            }
            if ((double)perc < 0.4) {
                healthStyle = completeText.method_10866().method_10977(class_124.field_1061);
            }
            if ((double)perc < 0.2) {
                healthStyle = completeText.method_10866().method_10977(class_124.field_1079);
            }
            class_5250 healthText = (class_5250)class_2561.method_30163((String)String.format(" (%d\u2764)", health));
            healthText.method_10862(healthStyle);
            completeText.method_10852((class_2561)healthText);
        }
        return completeText;
    }

    public static int countStackableItemsInRange(class_1937 world, class_243 center, double range, class_1799 targetItem) {
        int totalCount = 0;
        class_238 boundingBox = new class_238(center.method_10216() - range, center.method_10214() - range, center.method_10215() - range, center.method_10216() + range, center.method_10214() + range, center.method_10215() + range);
        for (class_1297 entity2 : world.method_8390(class_1297.class, boundingBox, entity -> entity instanceof class_1542)) {
            class_1542 itemEntity = (class_1542)entity2;
            class_1799 itemStack = itemEntity.method_6983();
            if (itemStack.method_7909() != targetItem.method_7909() || !itemStack.method_7964().equals((Object)targetItem.method_7964()) || !itemStack.method_58657().equals((Object)targetItem.method_58657())) continue;
            totalCount += itemStack.method_7947();
        }
        return totalCount;
    }

    @Nullable
    public static class_243 fastRaycast(class_1297 sourceEntity, boolean includeFluids, double maxDistance) {
        class_243 startPos = sourceEntity.method_5836(1.0f);
        class_243 lookVec = sourceEntity.method_5828(1.0f);
        double stepMultiplier = 0.5;
        double dx = lookVec.field_1352 * stepMultiplier;
        double dy = lookVec.field_1351 * stepMultiplier;
        double dz = lookVec.field_1350 * stepMultiplier;
        double x = startPos.field_1352;
        double y = startPos.field_1351;
        double z = startPos.field_1350;
        class_1937 world = sourceEntity.method_73183();
        class_243 prevPos = startPos;
        for (double distance = 0.0; distance < maxDistance; distance += 1.0 * stepMultiplier) {
            double yChange = y - prevPos.method_10214();
            class_2338 currentPos = new class_2338((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
            class_243 distancePos = new class_243(x, startPos.field_1351, z);
            double distanceToStart = startPos.method_1022(distancePos);
            if (distanceToStart > 256.0 || distanceToStart > maxDistance || currentPos.method_10264() > world.method_31605() && yChange > 0.0 || currentPos.method_10264() < world.method_31605() * -1 && yChange < 0.0) {
                return null;
            }
            class_2680 state = world.method_8320(currentPos);
            if (!state.method_26215()) {
                class_243 returnPos = new class_243(x, world.method_8320(currentPos.method_10069(0, 1, 0)).method_26215() ? y + 0.25 : y, z);
                if (!includeFluids) {
                    if (state.method_26227().method_15769()) {
                        return returnPos;
                    }
                } else {
                    return returnPos;
                }
            }
            prevPos = new class_243(x, y, z);
            x += dx;
            y += dy;
            z += dz;
        }
        return null;
    }

    @Nullable
    public static class_243 exactRaycast(class_1297 sourceEntity, boolean includeFluids, double maxDistance) {
        class_243 raycastDir;
        class_243 raycastEnd;
        class_243 playerPos;
        class_1937 world = sourceEntity.method_73183();
        class_3965 blockHitResult = world.method_17742(new class_3959(playerPos = sourceEntity.method_5836(1.0f), raycastEnd = playerPos.method_1019((raycastDir = sourceEntity.method_5828(1.0f)).method_1021(maxDistance)), class_3959.class_3960.field_17559, includeFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, sourceEntity));
        if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return blockHitResult.method_17784();
    }

    @Nullable
    public static RayResult fastEntityRaycast(class_1297 sourceEntity, double maxDistance) {
        class_243 start = sourceEntity.method_5836(1.0f);
        class_243 end = start.method_1019(sourceEntity.method_5828(1.0f).method_1021(maxDistance));
        class_238 searchBox = sourceEntity.method_5829().method_18804(end.method_1020(start)).method_1014(1.0);
        double closestDistance = Double.POSITIVE_INFINITY;
        class_243 pos = null;
        class_1297 hitEntity = null;
        for (class_1297 entity : sourceEntity.method_73183().method_8335(sourceEntity, searchBox)) {
            class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
            Optional hitResult = entityBox.method_992(start, end);
            if (entityBox.method_1006(start)) {
                if (!(closestDistance >= 0.0)) continue;
                closestDistance = 0.0;
                pos = start;
                continue;
            }
            if (!hitResult.isPresent()) continue;
            double distance = start.method_1022((class_243)hitResult.get());
            if (entity.method_5797() != null && entity.method_5797().equals((Object)noPingText) || !(distance < closestDistance) && closestDistance != 0.0) continue;
            closestDistance = distance;
            pos = (class_243)hitResult.get();
            hitEntity = entity;
        }
        if (pos == null || hitEntity == null) {
            return null;
        }
        return new RayResult(pos, hitEntity);
    }

    public static int removeOldPings(MinecraftServer server) {
        int removed = 0;
        for (class_3218 world : server.method_3738()) {
            ArrayList remove = new ArrayList();
            world.method_27909().forEach(entity -> {
                if (entity != null && entity.method_5797() != null && entity.method_5797().equals((Object)noPingText) && entities.stream().noneMatch(pingedEntity -> pingedEntity.getEntity().equals(entity))) {
                    remove.add(entity);
                }
            });
            removed += remove.size();
            remove.forEach(e -> e.method_5768(world));
        }
        return removed;
    }

    public static void tickInputCooldowns() {
        Iterator<Map.Entry<UUID, Integer>> iterator = playerCooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry = iterator.next();
            int updatedValue = entry.getValue() - 1;
            if (updatedValue < 0) {
                iterator.remove();
                continue;
            }
            entry.setValue(updatedValue);
        }
    }

    private static void tickOldPingCooldown(MinecraftServer server) {
        if (!VanillaPings.SETTINGS.isPingRemoveOld()) {
            return;
        }
        if (clearOldPingCooldown.isReady()) {
            PingManager.removeOldPings(server);
            clearOldPingCooldown.triggerCooldown();
        }
        clearOldPingCooldown.tick();
    }

    public static void tick(MinecraftServer server) {
        entities.forEach(PingedEntity::tick);
        entities.removeIf(PingedEntity::isDead);
        PingManager.tickInputCooldowns();
        PingManager.tickOldPingCooldown(server);
    }

    @FunctionalInterface
    public static interface CustomPingHandle {
        public void ping(class_243 var1, @Nullable class_1297 var2, class_1657 var3, class_1937 var4);
    }

    public record RayResult(class_243 position, @Nullable class_1297 entity) {
    }
}

