/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.features.ping;

import com.vanillapings.features.ping.HighlightSettings;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class PingedEntity {
    private boolean dead = false;
    private final int maxAge;
    private int age = 0;
    private final class_1297 entity;
    private final double startY;
    private final double amplitude = 0.1;
    private final double frequency = 0.1;
    private final float rotationSpeed = 100.0f;
    private int soundAge = 0;
    private float takeOffY = 0.0f;
    private boolean animate;
    private boolean kill;
    private boolean playSound;
    private HighlightSettings highlightSettings;

    public PingedEntity(class_1297 entity, int maxAge, boolean animate, boolean kill, boolean playSound, HighlightSettings highlightSettings) {
        this.entity = entity;
        this.maxAge = maxAge;
        this.animate = animate;
        this.highlightSettings = highlightSettings;
        this.playSound = playSound;
        this.kill = kill;
        this.startY = entity.method_23318();
    }

    public void tick() {
        if (this.dead) {
            return;
        }
        if (this.age == 0) {
            this.start();
        }
        if (this.animate) {
            this.animate();
        }
        if (this.highlightSettings.isHighlight() && this.shouldInterfereWithGlowing()) {
            this.highlightSettings.animate(this.age, this.maxAge, this.entity);
        }
        if (this.playSound) {
            this.audibilize();
        }
        if (this.age >= this.maxAge) {
            this.dead = true;
            this.end();
        }
        ++this.age;
    }

    private void start() {
        if (this.highlightSettings.isHighlight() && this.shouldInterfereWithGlowing()) {
            this.entity.method_5834(true);
        }
    }

    private void end() {
        if (this.shouldInterfereWithGlowing() && this.highlightSettings.isHighlight()) {
            this.entity.method_5834(false);
        }
        if (this.kill) {
            this.entity.method_5768((class_3218)this.entity.method_73183());
        }
    }

    private boolean shouldInterfereWithGlowing() {
        if (this.highlightSettings.isHighlight()) {
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                return !livingEntity.method_6026().stream().anyMatch(statusEffectInstance -> statusEffectInstance.method_5579().equals((Object)class_1294.field_5912));
            }
            return true;
        }
        return false;
    }

    private void audibilize() {
        if (this.soundAge == 0) {
            this.entity.method_73183().method_8396(null, this.entity.method_24515(), (class_3414)class_3417.field_18309.comp_349(), class_3419.field_15248, 10.0f, 1.0f);
        }
        if (this.soundAge == 5) {
            this.entity.method_73183().method_8396(null, this.entity.method_24515(), (class_3414)class_3417.field_14793.comp_349(), class_3419.field_15248, 10.0f, 1.0f);
        }
        if (this.soundAge == 7) {
            this.entity.method_73183().method_8396(null, this.entity.method_24515(), (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 10.0f, 1.5f);
        }
        if (this.age >= this.maxAge) {
            this.entity.method_73183().method_8396(null, this.entity.method_24515(), class_3417.field_26981, class_3419.field_15248, 10.0f, 1.25f);
        }
        ++this.soundAge;
    }

    private void animate() {
        double y = this.startY + (double)class_3532.method_15374((float)((float)((double)this.age * 0.1))) * 0.1 + 0.1;
        if (this.maxAge - this.age < 20) {
            y += (double)this.takeOffY;
            this.takeOffY = (float)((double)this.takeOffY + 0.1);
        }
        this.entity.method_23327(this.entity.method_23317(), y, this.entity.method_23321());
        float rotation = (float)this.age * 100.0f;
        rotation = class_3532.method_15393((float)rotation);
        this.entity.method_36456(rotation);
        if (this.age >= this.maxAge) {
            ((class_3218)this.entity.method_73183()).method_65096((class_2394)class_2398.field_11248, this.entity.method_23317(), this.entity.method_23318() + 1.2, this.entity.method_23321(), 10, 0.0, 0.0, 0.0, 0.0);
            ((class_3218)this.entity.method_73183()).method_65096((class_2394)class_2398.field_11251, this.entity.method_23317(), this.entity.method_23318() + 1.1, this.entity.method_23321(), 10, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isDead() {
        return this.dead;
    }

    public class_1297 getEntity() {
        return this.entity;
    }
}

