/*
 * Decompiled with CFR 0.152.
 */
package com.vanillapings.translation;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.vanillapings.VanillaPings;
import com.vanillapings.config.FileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class Translator {
    public static final String DEFAULT_LANGUAGE = "en_us";
    public static Map<String, Translator> languages = new HashMap<String, Translator>();
    private static final String RESOURCE_BASE = "assets/vanillapings/lang";
    private Map<String, String> translations;

    public static boolean loadLanguage(String name) {
        if (Translator.tryLoadFromFile(name)) {
            return true;
        }
        return Translator.tryLoadFromClasspath(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLoadFromClasspath(String name) {
        String resource = "assets/vanillapings/lang/" + name + ".json";
        try (InputStream in = VanillaPings.class.getClassLoader().getResourceAsStream(resource);){
            if (in == null) {
                VanillaPings.LOGGER.error("Failed to load {} language '{}': resource '{}' not found on classpath.", new Object[]{"VanillaPings", name, resource});
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = Translator.loadIntoRegistry(name, in);
            return bl;
        }
        catch (JsonParseException | IOException ex) {
            VanillaPings.LOGGER.error("Failed to load {} language '{}' from classpath.", new Object[]{"VanillaPings", name, ex});
            return false;
        }
    }

    private static boolean tryLoadFromFile(String name) {
        boolean bl;
        block9: {
            Path file = Paths.get(FileConfig.CONFIG_FOLDER, "lang", name + ".json");
            if (!Files.exists(file, new LinkOption[0])) {
                VanillaPings.LOGGER.info("No custom language file found for '{}'", (Object)name);
                return false;
            }
            InputStream in = Files.newInputStream(file, new OpenOption[0]);
            try {
                bl = Translator.loadIntoRegistry(name, in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException ex) {
                    VanillaPings.LOGGER.error("Failed to load {} custom language file for '{}'", new Object[]{"VanillaPings", name, ex});
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static boolean loadIntoRegistry(String languageName, InputStream in) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);){
            boolean bl;
            try (JsonReader reader = new JsonReader((Reader)isr);){
                Translator translator = new Translator();
                Gson gson = new Gson();
                translator.translations = (Map)gson.fromJson(reader, new TypeToken<Map<String, String>>(){}.getType());
                languages.put(languageName, translator);
                bl = true;
            }
            return bl;
        }
    }

    public String get(String key) {
        if (!this.translations.containsKey(key = this.parseKey(key))) {
            return key;
        }
        return this.translations.get(key);
    }

    public class_5250 getAsText(String key) {
        return class_2561.method_43470((String)this.get(key));
    }

    private String parseKey(String key) {
        if (key.contains(":")) {
            return class_2960.method_60654((String)key).method_42094();
        }
        return key;
    }

    public static void clearTranslators() {
        languages.clear();
    }

    public static Translator getTranslator(String key) {
        if (!languages.containsKey(key)) {
            Translator.loadLanguage(key);
        }
        if (!languages.containsKey(key)) {
            VanillaPings.LOGGER.error("Can't load translator for " + key + " falling back to: en_us");
            Translator.loadLanguage(DEFAULT_LANGUAGE);
            return languages.get(DEFAULT_LANGUAGE);
        }
        return languages.get(key);
    }

    public static Translator getTranslator() {
        return Translator.getTranslator(VanillaPings.SETTINGS.getDefaultLanguage());
    }
}

