/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.FlipBackC2SPacket;
import org.teacon.slides.network.Network;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Utilities;

public class FlipperItem
extends Item {
    private static boolean attackKeyDown = false;

    public FlipperItem(Item.Properties properties) {
        super(properties);
    }

    public static int[] getProjectorPos(ItemStack stack) {
        if (!stack.m_150930_((Item)Slideshow.FLIPPER_ITEM.get()) || !stack.m_41782_() || stack.m_41783_().m_128465_("projector") == null) {
            return null;
        }
        int[] intArray = stack.m_41783_().m_128465_("projector");
        if (intArray == null || intArray.length < 3) {
            return null;
        }
        return intArray;
    }

    public static void setProjectorPos(ItemStack stack, @Nullable BlockPos pos) {
        if (!stack.m_150930_((Item)Slideshow.FLIPPER_ITEM.get())) {
            return;
        }
        if (pos == null) {
            stack.m_41749_("projector");
            return;
        }
        stack.m_41700_("projector", (Tag)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }

    public static boolean trySendFlip(Level world, ServerPlayer player, ItemStack itemStack, boolean back, boolean init) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            Utilities.sendOverLayMessage((Player)player, (Component)Component.m_237115_((String)"info.slide_show.need_bound").m_130940_(ChatFormatting.DARK_RED));
            return false;
        }
        BlockEntity entity = world.m_7702_(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(entity instanceof ProjectorBlockEntity)) {
            Utilities.sendOverLayMessage((Player)player, (Component)Component.m_237115_((String)"info.slide_show.binding_lost").m_130940_(ChatFormatting.DARK_RED));
            FlipperItem.setProjectorPos(itemStack, null);
            return false;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!FlipperItem.hasFlipperPermission(player)) {
            return false;
        }
        if (!entity1.canFlip()) {
            return false;
        }
        if (init) {
            entity1.needInitContainer = true;
            Utilities.sendOverLayMessage((Player)player, (Component)Component.m_237115_((String)"info.slide_show.initialized").m_130940_(ChatFormatting.AQUA));
            return true;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        Utilities.sendOverLayMessage((Player)player, (Component)Component.m_237115_((String)"info.slide_show.slide_flipped").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    private static boolean hasFlipperPermission(ServerPlayer player) {
        return player.m_7500_() || player.f_8941_.m_9290_() == GameType.SURVIVAL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
        }
        if (FlipperItem.trySendFlip(world, (ServerPlayer)player, itemStack, false, player.m_6144_())) {
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)true);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemStack, world, entity, slot, selected);
        if (world.m_5776_() && selected && attackKeyDown != Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
            boolean bl = attackKeyDown = !attackKeyDown;
            if (attackKeyDown) {
                FlipperItem.sendServerFlipBack(slot);
            }
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag tooltipFlag) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            list.add((Component)Component.m_237115_((String)"item.slide_show.flipper.tooltip.not_bound").m_130940_(ChatFormatting.RED));
            list.add((Component)Component.m_237115_((String)"item.slide_show.flipper.tooltip.not_bound1"));
            super.m_7373_(itemStack, world, list, tooltipFlag);
            return;
        }
        list.add((Component)Component.m_237110_((String)"item.slide_show.flipper.tooltip.bound", (Object[])new Object[]{pos[0], pos[1], pos[2]}).m_130940_(ChatFormatting.AQUA));
        super.m_7373_(itemStack, world, list, tooltipFlag);
    }

    private static void sendServerFlipBack(int i) {
        Network.CHANNEL.send((Object)new FlipBackC2SPacket(i), PacketDistributor.SERVER.noArg());
    }

    public boolean m_6777_(BlockState blockState, Level world, BlockPos blockPos, Player player) {
        return false;
    }
}

