/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;
import org.teacon.slides.Slideshow;
import org.teacon.slides.cache.CacheStorage;
import org.teacon.slides.config.Config;
import org.teacon.slides.http.client.cache.HttpCacheContext;
import org.teacon.slides.http.impl.client.cache.CacheConfig;
import org.teacon.slides.http.impl.client.cache.CachingHttpClients;

public final class ImageCache {
    private static final Logger LOGGER = LogManager.getLogger(Slideshow.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"Cache");
    private static final Path LOCAL_CACHE_PATH = Paths.get("slideshow", new String[0]);
    private static volatile ImageCache sInstance;
    private static final int MAX_CACHE_OBJECT_SIZE = 0x20000000;
    private static final CacheConfig CONFIG;
    private static final String DEFAULT_REFERER = "https://github.com/jonafanho/Slideshow";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";
    private final CloseableHttpClient mHttpClient;
    private final CacheStorage mCacheStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageCache getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            if (sInstance == null) {
                sInstance = new ImageCache(LOCAL_CACHE_PATH);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private ImageCache(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create cache directory for slide images.", e);
        }
        this.mCacheStorage = new CacheStorage(dir);
        this.mHttpClient = Config.isProxySwitch() ? CachingHttpClients.custom().setCacheConfig(CONFIG).setHttpCacheStorage(this.mCacheStorage).setProxy(Config.getPROXY()).build() : CachingHttpClients.custom().setCacheConfig(CONFIG).setHttpCacheStorage(this.mCacheStorage).build();
    }

    @NotNull
    public CompletableFuture<byte[]> getResource(@NotNull URI location, boolean online) {
        return CompletableFuture.supplyAsync(() -> {
            HttpCacheContext context = HttpCacheContext.create();
            try {
                CloseableHttpResponse response = this.createResponse(location, context, online);
                try {
                    byte[] byArray = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                    return byArray;
                }
                catch (IOException e) {
                    if (!online) throw new CompletionException(e);
                    LOGGER.warn(MARKER, "Failed to read bytes from remote source.", (Throwable)e);
                    throw new CompletionException(e);
                }
                finally {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (ClientProtocolException protocolError) {
                LOGGER.warn(MARKER, "Detected invalid client protocol.", (Throwable)protocolError);
                throw new CompletionException(protocolError);
            }
            catch (IOException connError) {
                LOGGER.warn(MARKER, "Failed to establish connection.", (Throwable)connError);
                throw new CompletionException(connError);
            }
        });
    }

    @NotNull
    public CompletableFuture<byte[]> getResourceFromPack(@NotNull ResourceLocation location) {
        return CompletableFuture.supplyAsync(() -> {
            Minecraft mc = Minecraft.m_91087_();
            try {
                return IOUtils.toByteArray((InputStream)mc.m_91098_().m_142591_(location).m_6679_());
            }
            catch (IOException e) {
                LOGGER.warn(MARKER, "Failed to read bytes from resource pack.", (Throwable)e);
                throw new CompletionException(e);
            }
        });
    }

    private CloseableHttpResponse createResponse(URI location, HttpCacheContext context, boolean online) throws IOException {
        HttpGet request = new HttpGet(location);
        request.addHeader("Referer", DEFAULT_REFERER);
        request.addHeader("User-Agent", DEFAULT_USER_AGENT);
        request.addHeader("Accept", String.join((CharSequence)", ", ImageIO.getReaderMIMETypes()));
        if (!online) {
            request.addHeader("Cache-Control", "max-stale=2147483647");
            request.addHeader("Cache-Control", "only-if-cached");
        } else {
            request.addHeader("Cache-Control", "must-revalidate");
        }
        return this.mHttpClient.execute((HttpUriRequest)request, (HttpContext)context);
    }

    private void logRequestHeader(@NotNull HttpCacheContext context) {
        LOGGER.debug(MARKER, " >> {}", (Object)context.getRequest().getRequestLine());
        for (Header header : context.getRequest().getAllHeaders()) {
            LOGGER.debug(MARKER, " >> {}", (Object)header);
        }
        LOGGER.debug(MARKER, " << {}", (Object)context.getResponse().getStatusLine());
        for (Header header : context.getResponse().getAllHeaders()) {
            LOGGER.debug(MARKER, " << {}", (Object)header);
        }
        LOGGER.debug(MARKER, "Remote server status: {}", (Object)context.getCacheResponseStatus());
    }

    public int cleanResources() {
        return this.mCacheStorage.cleanResources();
    }

    static {
        CONFIG = CacheConfig.custom().setMaxObjectSize(0x20000000L).setSharedCache(false).build();
    }
}

