/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPacket;
import org.teacon.slides.network.ProjectorExportC2SPacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;

public final class ProjectorScreen
extends AbstractContainerScreen<ProjectorScreenHandler> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.m_214293_((String)"slide_show", (String)"textures/gui/projector.png");
    private static final Component IMAGE_TEXT = Component.m_237115_((String)"gui.slide_show.section.image");
    private static final Component OFFSET_TEXT = Component.m_237115_((String)"gui.slide_show.section.offset");
    private static final Component OTHERS_TEXT = Component.m_237115_((String)"gui.slide_show.section.others");
    private static final Component URL_TEXT = Component.m_237115_((String)"gui.slide_show.url");
    private static final Component ID_TEXT = Component.m_237115_((String)"gui.slide_show.id");
    private static final Component EXPORT_TEXT = Component.m_237115_((String)"gui.slide_show.export");
    private static final Component CONTAINER_TEXT = Component.m_237115_((String)"gui.slide_show.container");
    private static final Component COLOR_TEXT = Component.m_237115_((String)"gui.slide_show.color");
    private static final Component WIDTH_TEXT = Component.m_237115_((String)"gui.slide_show.width");
    private static final Component HEIGHT_TEXT = Component.m_237115_((String)"gui.slide_show.height");
    private static final Component OFFSET_X_TEXT = Component.m_237115_((String)"gui.slide_show.offset_x");
    private static final Component OFFSET_Y_TEXT = Component.m_237115_((String)"gui.slide_show.offset_y");
    private static final Component OFFSET_Z_TEXT = Component.m_237115_((String)"gui.slide_show.offset_z");
    private static final Component FLIP_TEXT = Component.m_237115_((String)"gui.slide_show.flip");
    private static final Component ROTATE_TEXT = Component.m_237115_((String)"gui.slide_show.rotate");
    private static final Component SINGLE_DOUBLE_SIDED_TEXT = Component.m_237115_((String)"gui.slide_show.single_double_sided");
    private EditBox mURLInput;
    private EditBox mColorInput;
    private EditBox mWidthInput;
    private EditBox mHeightInput;
    private EditBox mOffsetXInput;
    private EditBox mOffsetYInput;
    private EditBox mOffsetZInput;
    private ImageButton mSwitchURL;
    private ImageButton mSwitchID;
    private ImageButton mSwitchContainer;
    private ImageButton mButtonExport;
    private ImageButton mSwitchSingleSided;
    private ImageButton mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private Vec2 mImageSize = Vec2.f_82463_;
    private Vector3f mImageOffset = new Vector3f();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.mURLInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 29, 137, 16, (Component)Component.m_237115_((String)"gui.slide_show.url"));
        this.mURLInput.m_94199_(512);
        this.mURLInput.m_94151_(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (ResourceLocation.m_135820_((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.m_94202_(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.m_94144_(this.mEntity.mLocation);
        this.m_142416_((GuiEventListener)this.mURLInput);
        this.m_264313_((GuiEventListener)this.mURLInput);
        this.mColorInput = new EditBox(this.f_96547_, leftPos + 55, topPos + 155, 56, 16, (Component)Component.m_237115_((String)"gui.slide_show.color"));
        this.mColorInput.m_94199_(8);
        this.mColorInput.m_94151_(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.m_94202_(this.mInvalidColor ? 14699339 : 0xE0E0E0);
        });
        this.mColorInput.m_94144_(String.format("%08X", this.mEntity.mColor));
        this.m_142416_((GuiEventListener)this.mColorInput);
        this.mWidthInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 51, 56, 16, (Component)Component.m_237115_((String)"gui.slide_show.width"));
        this.mWidthInput.m_94151_(text -> {
            try {
                Vec2 newSize = new Vec2(ProjectorScreen.parseFloat(text), this.mImageSize.f_82471_);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.m_94202_(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
        });
        this.mWidthInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.m_142416_((GuiEventListener)this.mWidthInput);
        this.mHeightInput = new EditBox(this.f_96547_, leftPos + 111, topPos + 51, 56, 16, (Component)Component.m_237115_((String)"gui.slide_show.height"));
        this.mHeightInput.m_94151_(input -> {
            try {
                Vec2 newSize = new Vec2(this.mImageSize.f_82470_, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.m_94202_(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
        });
        this.mHeightInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.m_142416_((GuiEventListener)this.mHeightInput);
        this.mOffsetXInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 103, 29, 16, (Component)Component.m_237115_((String)"gui.slide_show.offset_x"));
        this.mOffsetXInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(ProjectorScreen.parseFloat(input), this.mImageOffset.y(), this.mImageOffset.z());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.m_94202_(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.m_142416_((GuiEventListener)this.mOffsetXInput);
        this.mOffsetYInput = new EditBox(this.f_96547_, leftPos + 84, topPos + 103, 29, 16, (Component)Component.m_237115_((String)"gui.slide_show.offset_y"));
        this.mOffsetYInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), ProjectorScreen.parseFloat(input), this.mImageOffset.z());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.m_94202_(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.m_142416_((GuiEventListener)this.mOffsetYInput);
        this.mOffsetZInput = new EditBox(this.f_96547_, leftPos + 138, topPos + 103, 29, 16, (Component)Component.m_237115_((String)"gui.slide_show.offset_z"));
        this.mOffsetZInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), this.mImageOffset.y(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.m_94202_(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.m_142416_((GuiEventListener)this.mOffsetZInput);
        this.m_142416_((GuiEventListener)new ImageButton(leftPos + 117, topPos + 153, 18, 19, 179, 153, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(leftPos + 142, topPos + 153, 18, 19, 179, 173, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(Rotation.CLOCKWISE_90);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.m_58900_().m_61143_(ProjectorBlock.ROTATION));
        this.mSwitchURL = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 53, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.f_93624_ = true;
            this.mSwitchURL.f_93624_ = false;
        });
        this.mSwitchID = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 73, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.f_93624_ = true;
            this.mSwitchID.f_93624_ = false;
            this.mButtonExport.f_93624_ = false;
        });
        this.mSwitchContainer = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 93, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.f_93624_ = true;
            this.mSwitchContainer.f_93624_ = false;
            this.mButtonExport.f_93624_ = true;
        });
        this.mButtonExport = new ImageButton(leftPos + 149, topPos + 7, 18, 19, 179, 33, 0, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 113, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchDoubleSided.f_93624_ = true;
            this.mSwitchSingleSided.f_93624_ = false;
        });
        this.mSwitchDoubleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 133, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchSingleSided.f_93624_ = true;
            this.mSwitchDoubleSided.f_93624_ = false;
        });
        this.mSwitchURL.f_93624_ = this.mSourceType == SourceType.URL;
        this.mSwitchID.f_93624_ = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.f_93624_ = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.f_93624_ = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.f_93624_ = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.f_93624_ = !this.mDoubleSided;
        this.m_142416_((GuiEventListener)this.mSwitchURL);
        this.m_142416_((GuiEventListener)this.mSwitchID);
        this.m_142416_((GuiEventListener)this.mSwitchContainer);
        this.m_142416_((GuiEventListener)this.mButtonExport);
        this.m_142416_((GuiEventListener)this.mSwitchSingleSided);
        this.m_142416_((GuiEventListener)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(Vec2 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mImageSize = newSize;
    }

    protected void m_181908_() {
        if (this.mEntity == null) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        this.mURLInput.m_94120_();
        this.mColorInput.m_94120_();
        this.mWidthInput.m_94120_();
        this.mHeightInput.m_94120_();
        this.mOffsetXInput.m_94120_();
        this.mOffsetYInput.m_94120_();
        this.mOffsetZInput.m_94120_();
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        Network.CHANNEL.sendToServer((Object)new ProjectorExportC2SPacket(this.mSourceType == SourceType.ResourceID, this.mURLInput.m_94155_()));
    }

    public void m_7861_() {
        boolean invalidOffset;
        super.m_7861_();
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.m_94155_();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.f_82470_;
            this.mEntity.mHeight = this.mImageSize.f_82471_;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.x();
            this.mEntity.mOffsetY = this.mImageOffset.y();
            this.mEntity.mOffsetZ = this.mImageOffset.z();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType != this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        Network.CHANNEL.sendToServer((Object)new ProjectorAfterUpdateC2SPacket(this.mEntity, this.mRotation));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return this.mURLInput.m_7933_(keyCode, scanCode, modifier) || this.mURLInput.m_94204_() || this.mColorInput.m_7933_(keyCode, scanCode, modifier) || this.mColorInput.m_94204_() || this.mWidthInput.m_7933_(keyCode, scanCode, modifier) || this.mWidthInput.m_94204_() || this.mHeightInput.m_7933_(keyCode, scanCode, modifier) || this.mHeightInput.m_94204_() || this.mOffsetXInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetXInput.m_94204_() || this.mOffsetYInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetYInput.m_94204_() || this.mOffsetZInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetZInput.m_94204_() || super.m_7933_(keyCode, scanCode, modifier);
    }

    public void m_88315_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.m_280273_(ctx);
        super.m_88315_(ctx, mouseX, mouseY, delta);
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.m_280218_(GUI_TEXTURE, (this.f_96543_ - this.imageWidth) / 2, (this.f_96544_ - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void m_280003_(GuiGraphics ctx, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
            ctx.m_280218_(GUI_TEXTURE, 38, 131, 180, 194, 10, 10);
            ctx.m_280218_(GUI_TEXTURE, 82, 159, 180, 194, 17, 17);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ctx.m_280218_(GUI_TEXTURE, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.f_96547_, IMAGE_TEXT, this.imageWidth / 2, -14);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.f_96547_, OFFSET_TEXT, this.imageWidth / 2, 60);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.f_96547_, OTHERS_TEXT, this.imageWidth / 2, 112);
        int offsetX = mouseX - (this.f_96543_ - this.imageWidth) / 2;
        int offsetY = mouseY - (this.f_96544_ - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            ctx.m_280557_(this.f_96547_, switch (this.mSourceType) {
                case SourceType.ResourceID -> ID_TEXT;
                case SourceType.ContainerBlock -> CONTAINER_TEXT;
                default -> URL_TEXT;
            }, offsetX, offsetY);
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                ctx.m_280557_(this.f_96547_, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            ctx.m_280557_(this.f_96547_, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
            ctx.m_280557_(this.f_96547_, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 49 && offsetX < 108 && offsetY < 68) {
            ctx.m_280557_(this.f_96547_, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
            ctx.m_280557_(this.f_96547_, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
            ctx.m_280557_(this.f_96547_, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
            ctx.m_280557_(this.f_96547_, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            ctx.m_280557_(this.f_96547_, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            ctx.m_280557_(this.f_96547_, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            ctx.m_280557_(this.f_96547_, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(GuiGraphics ctx, Font textRenderer, Component text, int centerX, int y) {
        FormattedCharSequence orderedText = text.m_7532_();
        ctx.m_280614_(textRenderer, text, centerX - textRenderer.m_92724_(orderedText) / 2, y, 0x404040, false);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.f_82470_, 0.0f, 0.5f * size.f_82471_, 1.0f);
        center.mul((Matrix4fc)new Matrix4f().translate(relatedOffset.x(), -relatedOffset.z(), relatedOffset.y()));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f, 0.0f, 0.5f - size.f_82471_));
        rotation.transform(center);
        return new Vector3f(center.x(), center.y(), center.z());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f((Vector3fc)absoluteOffset, 1.0f);
        rotation.invert().transform(center);
        center.mul((Matrix4fc)new Matrix4f().translate(0.5f, 0.0f, -0.5f + size.f_82471_));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f * size.f_82470_, 0.0f, -0.5f * size.f_82471_));
        return new Vector3f(center.x(), center.z(), -center.y());
    }
}

