/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.teacon.slides.Slideshow;
import org.teacon.slides.util.ClientUtilities;

public class ImageItem
extends Item {
    public ImageItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag type) {
        String location = (String)itemStack.get(Slideshow.LOCATION_COMPONENT);
        if (location == null) {
            list.add((Component)Component.translatable((String)"item.slide_show.image.tooltip.no_properties").withStyle(ChatFormatting.DARK_RED));
            super.appendHoverText(itemStack, context, list, type);
            return;
        }
        boolean bl = Boolean.TRUE.equals(itemStack.get(Slideshow.FROM_ID_COMPONENT));
        list.add((Component)Component.translatable((String)(bl ? "item.slide_show.image.tooltip.id" : "item.slide_show.image.tooltip.url")).withStyle(ChatFormatting.AQUA));
        list.add((Component)Component.literal((String)location).withStyle(ChatFormatting.AQUA));
        super.appendHoverText(itemStack, context, list, type);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 0;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack != null && !itemStack.isEmpty()) {
            ClientUtilities.clientSetScreen(hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

