/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.ProjectorImageInfoS2CPayload;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;

public final class ProjectorBlockEntity
extends BlockEntity
implements MenuProvider {
    public SourceType mSourceType = SourceType.URL;
    public String mLocation = "";
    public int mColor = -1;
    public float mWidth = 1.0f;
    public float mHeight = 1.0f;
    public float mOffsetX = 0.0f;
    public float mOffsetY = 0.0f;
    public float mOffsetZ = 0.0f;
    public boolean mDoubleSided = true;
    public Container mContainer = null;
    public int scanIndex = -1;
    public boolean needInitContainer = false;
    public boolean needHandleReadImage = false;
    public boolean flipBack = false;
    public boolean mCFromID = false;
    public String mCLocation = "";
    public boolean mCNextFromID = false;
    public String mCNextLocation = "";

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void transformToSlideSpace(Matrix4f pose, Matrix3f normal) {
        BlockState state = this.getBlockState();
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.getValue(ProjectorBlock.ROTATION));
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.rotate((Quaternionfc)direction.getRotation());
        normal.rotate((Quaternionfc)direction.getRotation());
        pose.translate(0.0f, 0.5f, 0.0f);
        rotation.transform(pose);
        rotation.transform(normal);
        pose.translate(-0.5f, 0.0f, 0.5f - this.mHeight);
        pose.translate(this.mOffsetX, -this.mOffsetZ, this.mOffsetY);
        pose.scale(this.mWidth, 1.0f, this.mHeight);
    }

    private boolean tryReadImageItem(ItemStack item, boolean next) {
        String loc;
        if (item.is(Slideshow.IMAGE_ITEM) && (loc = (String)item.get(Slideshow.LOCATION_COMPONENT)) != null) {
            if (next) {
                this.mCNextFromID = Boolean.TRUE.equals(item.get(Slideshow.FROM_ID_COMPONENT));
                this.mCNextLocation = loc;
            } else {
                this.mCFromID = Boolean.TRUE.equals(item.get(Slideshow.FROM_ID_COMPONENT));
                this.mCLocation = loc;
            }
            return true;
        }
        return false;
    }

    private void handleReadImage(boolean back) {
        ItemStack item;
        int i;
        int j;
        int size = this.mContainer.getContainerSize();
        if (size <= 0) {
            return;
        }
        int start = back ? size + this.scanIndex - 1 : this.scanIndex + 1;
        int end = back ? this.scanIndex - 1 : size + this.scanIndex + 1;
        boolean found = false;
        if (back) {
            for (j = start; j > end; --j) {
                i = j % size;
                item = this.mContainer.getItem(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        } else {
            for (j = start; j < end; ++j) {
                i = j % size;
                item = this.mContainer.getItem(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        }
        if (!found) {
            this.mCNextLocation = "";
            return;
        }
        for (j = start; j < end; ++j) {
            i = j % size;
            item = this.mContainer.getItem(i);
            if (!this.tryReadImageItem(item, true)) continue;
            return;
        }
    }

    public boolean canFlip() {
        return this.mSourceType == SourceType.ContainerBlock && this.mContainer != null;
    }

    public boolean getFromID() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mSourceType == SourceType.ResourceID;
        }
        return this.mCFromID;
    }

    public String getLocation() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mLocation;
        }
        return this.mCLocation;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.saveCompound(nbt);
        super.saveAdditional(nbt, registryLookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.loadCompound(nbt);
        super.loadAdditional(nbt, registryLookup);
    }

    public void saveCompound(CompoundTag compoundTag) {
        compoundTag.putString("SourceType", switch (this.mSourceType) {
            case SourceType.ResourceID -> "resource_id";
            case SourceType.ContainerBlock -> "container";
            default -> "url";
        });
        compoundTag.putString("ImageLocation", this.mLocation);
        compoundTag.putInt("Color", this.mColor);
        compoundTag.putFloat("Width", this.mWidth);
        compoundTag.putFloat("Height", this.mHeight);
        compoundTag.putFloat("OffsetX", this.mOffsetX);
        compoundTag.putFloat("OffsetY", this.mOffsetY);
        compoundTag.putFloat("OffsetZ", this.mOffsetZ);
        compoundTag.putBoolean("DoubleSided", this.mDoubleSided);
        compoundTag.putInt("ScanIndex", this.scanIndex);
        compoundTag.putBoolean("CFromID", this.mCFromID);
        compoundTag.putString("CLocation", this.mCLocation);
        compoundTag.putBoolean("CNextFromID", this.mCNextFromID);
        compoundTag.putString("CNextLocation", this.mCNextLocation);
    }

    public void loadCompound(CompoundTag compoundTag) {
        this.mSourceType = switch (compoundTag.getString("SourceType")) {
            case "resource_id" -> SourceType.ResourceID;
            case "container" -> SourceType.ContainerBlock;
            default -> SourceType.URL;
        };
        this.mLocation = compoundTag.getString("ImageLocation");
        this.mColor = compoundTag.getInt("Color");
        this.mWidth = compoundTag.getFloat("Width");
        this.mHeight = compoundTag.getFloat("Height");
        this.mOffsetX = compoundTag.getFloat("OffsetX");
        this.mOffsetY = compoundTag.getFloat("OffsetY");
        this.mOffsetZ = compoundTag.getFloat("OffsetZ");
        this.mDoubleSided = compoundTag.getBoolean("DoubleSided");
        this.scanIndex = compoundTag.getInt("ScanIndex");
        this.mCFromID = compoundTag.getBoolean("CFromID");
        this.mCLocation = compoundTag.getString("CLocation");
        this.mCNextFromID = compoundTag.getBoolean("CNextFromID");
        this.mCNextLocation = compoundTag.getString("CNextLocation");
    }

    public void sync() {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)this.level), (CustomPacketPayload)new ProjectorImageInfoS2CPayload(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void tick(Level world, BlockPos pos, ProjectorBlockEntity entity) {
        if (world.isClientSide()) {
            return;
        }
        if (entity.mSourceType != SourceType.ContainerBlock) {
            return;
        }
        entity.mContainer = HopperBlockEntity.getContainerAt((Level)world, (BlockPos)ProjectorBlockEntity.tryParseCoor(entity.mLocation, pos));
        if (entity.mContainer == null) {
            entity.mCLocation = "";
            entity.mCNextLocation = "";
            entity.scanIndex = -1;
            return;
        }
        if (entity.needInitContainer) {
            entity.scanIndex = -1;
            entity.handleReadImage(false);
            entity.needInitContainer = false;
            entity.setChanged();
            entity.sync();
            return;
        }
        if (entity.needHandleReadImage) {
            if (entity.scanIndex < 0) {
                entity.scanIndex = -1;
                entity.handleReadImage(false);
                return;
            }
            entity.handleReadImage(entity.flipBack);
            entity.setChanged();
            entity.sync();
            entity.needHandleReadImage = false;
            entity.flipBack = false;
        }
    }

    private static BlockPos tryParseCoor(String coor, BlockPos pos) {
        try {
            String[] xyz = coor.split("\\s+");
            int[] nPos = new int[3];
            String x = xyz[0];
            nPos[0] = x.startsWith("~") ? pos.getX() + ProjectorBlockEntity.parseInt(x.substring(1)) : ProjectorBlockEntity.parseInt(x);
            String y = xyz[1];
            nPos[1] = y.startsWith("~") ? pos.getY() + ProjectorBlockEntity.parseInt(y.substring(1)) : ProjectorBlockEntity.parseInt(y);
            String z = xyz[2];
            nPos[2] = z.startsWith("~") ? pos.getZ() + ProjectorBlockEntity.parseInt(z.substring(1)) : ProjectorBlockEntity.parseInt(z);
            return new BlockPos(nPos[0], nPos[1], nPos[2]);
        }
        catch (Exception e) {
            return pos.below();
        }
    }

    private static int parseInt(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, registryLookup);
        return compoundTag;
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBlockPos(this.worldPosition);
        return new ProjectorScreenHandler(syncId, buf);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

