/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.FlipperFlipBackC2SPayload;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.RegistryClient;
import org.teacon.slides.util.Utilities;

public class FlipperItem
extends class_1792 {
    private static boolean attackKeyDown = false;

    public FlipperItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static List<Integer> getProjectorPos(class_1799 stack) {
        if (!stack.method_31574(Slideshow.FLIPPER_ITEM)) {
            return null;
        }
        List intArray = (List)stack.method_58694(Slideshow.PROJECTOR_COMPONENT);
        if (intArray == null || intArray.size() < 3) {
            return null;
        }
        return intArray;
    }

    public static void setProjectorPos(class_1799 stack, @Nullable class_2338 pos) {
        if (!stack.method_31574(Slideshow.FLIPPER_ITEM)) {
            return;
        }
        if (pos == null) {
            stack.method_57381(Slideshow.PROJECTOR_COMPONENT);
            return;
        }
        stack.method_57379(Slideshow.PROJECTOR_COMPONENT, Arrays.asList(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public static boolean trySendFlip(class_1937 world, class_3222 player, class_1799 itemStack, boolean back, boolean init) {
        List<Integer> pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.need_bound").method_27692(class_124.field_1079));
            return false;
        }
        class_2586 entity = world.method_8321(new class_2338(pos.get(0).intValue(), pos.get(1).intValue(), pos.get(2).intValue()));
        if (!(entity instanceof ProjectorBlockEntity)) {
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.binding_lost").method_27692(class_124.field_1079));
            FlipperItem.setProjectorPos(itemStack, null);
            return false;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!FlipperItem.hasFlipperPermission(player)) {
            return false;
        }
        if (!entity1.canFlip()) {
            return false;
        }
        if (init) {
            entity1.needInitContainer = true;
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.initialized").method_27692(class_124.field_1075));
            return true;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.slide_flipped").method_27692(class_124.field_1075));
        return true;
    }

    private static boolean hasFlipperPermission(class_3222 player) {
        return player.method_68878() || player.field_13974.method_14257() == class_1934.field_9215;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (FlipperItem.trySendFlip(world, (class_3222)user, itemStack, false, user.method_5715())) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 stack = context.method_8041();
        if (stack.method_31574(Slideshow.FLIPPER_ITEM)) {
            class_2338 pos = context.method_8037();
            class_1657 player = context.method_8036();
            if (player == null) {
                return class_1269.field_5814;
            }
            if (world.method_8321(pos) instanceof ProjectorBlockEntity) {
                FlipperItem.setProjectorPos(stack, pos);
                Utilities.sendOverLayMessage(player, (class_2561)class_2561.method_43471((String)"info.slide_show.bound_projector").method_27692(class_124.field_1075));
                return class_1269.field_21466;
            }
            return FlipperItem.trySendFlip(world, (class_3222)player, stack, false, player.method_5715()) ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void clientPlayerTick(class_1657 player) {
        if (player.method_6047().method_31574(Slideshow.FLIPPER_ITEM) && attackKeyDown != class_310.method_1551().field_1690.field_1886.method_1434()) {
            boolean bl = attackKeyDown = !attackKeyDown;
            if (attackKeyDown) {
                FlipperItem.sendServerFlipBack();
            }
        }
    }

    public static void appendTooltip(class_1799 itemStack, List<class_2561> list) {
        List<Integer> pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            list.add((class_2561)class_2561.method_43471((String)"item.slide_show.flipper.tooltip.not_bound").method_27692(class_124.field_1061));
            list.add((class_2561)class_2561.method_43471((String)"item.slide_show.flipper.tooltip.not_bound1"));
            return;
        }
        list.add((class_2561)class_2561.method_43469((String)"item.slide_show.flipper.tooltip.bound", (Object[])new Object[]{pos.get(0), pos.get(1), pos.get(2)}).method_27692(class_124.field_1075));
    }

    private static void sendServerFlipBack() {
        RegistryClient.sendToServer(new FlipperFlipBackC2SPayload());
    }

    public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 user) {
        return false;
    }
}

