/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_827;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.teacon.slides.config.Config;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.Slide;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.RenderTaskManager;

public class ProjectorRenderer
implements class_827<ProjectorBlockEntity> {
    public void render(ProjectorBlockEntity blockEntity, float partialTick, class_4587 matrices, class_4597 source, int packedLight, int packedOverlay, class_243 cameraPos) {
        RenderTaskManager.replayQueue();
        class_2680 state = blockEntity.method_11010();
        Slide slide = SlideState.getSlide(blockEntity.getLocation(), blockEntity.getFromID());
        if (blockEntity.mSourceType == SourceType.ContainerBlock) {
            SlideState.cacheSlide(blockEntity.mCNextLocation, blockEntity.mCNextFromID);
        }
        if (slide == null) {
            return;
        }
        float width = blockEntity.mWidth;
        float height = blockEntity.mHeight;
        int color = blockEntity.mColor;
        boolean isTransparent = (color & 0xFF000000) == 0;
        boolean isPowered = (Boolean)state.method_11654((class_2769)class_2741.field_12484);
        boolean doubleSided = blockEntity.mDoubleSided;
        if (!isTransparent && !isPowered) {
            matrices.method_22903();
            class_4587.class_4665 lastPose = matrices.method_23760();
            Matrix4f pose = new Matrix4f((Matrix4fc)lastPose.method_23761());
            Matrix3f normal = new Matrix3f((Matrix3fc)lastPose.method_23762());
            blockEntity.transformToSlideSpace(pose, normal);
            boolean flipped = ((ProjectorBlock.InternalRotation)((Object)state.method_11654(ProjectorBlock.ROTATION))).isFlipped();
            slide.render(source, pose, lastPose, width, height, color, packedLight, class_4608.field_21444, flipped || doubleSided, !flipped || doubleSided, SlideState.getAnimationTick(), partialTick);
            matrices.method_22909();
        }
    }

    public boolean rendersOutsideBoundingBox(ProjectorBlockEntity tile) {
        return true;
    }

    public int method_33893() {
        return Config.getRenderDistance();
    }
}

