/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1011;
import net.minecraft.class_10868;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL12C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.TextureProvider;
import org.teacon.slides.texture.WebPDecoder;

public final class StaticTextureProvider
implements TextureProvider {
    private int mTexture;
    private GpuTexture mGpuTexture;
    private final SlideRenderType mRenderType;
    private final int mWidth;
    private final int mHeight;

    public StaticTextureProvider(byte @NotNull [] data, boolean isWebP) {
        ByteBuffer buffer = isWebP ? MemoryUtil.memAlloc((int)0) : MemoryUtil.memAlloc((int)data.length).put(data).rewind();
        try (class_1011 image = isWebP ? WebPDecoder.toNativeImage(data) : StaticTextureProvider.createNativeImage(class_1011.class_1012.field_4997, buffer);){
            if (image == null) {
                throw new IOException();
            }
            this.mWidth = image.method_4307();
            this.mHeight = image.method_4323();
            int maxLevel = Math.min(31 - Integer.numberOfLeadingZeros(Math.max(this.mWidth, this.mHeight)), 4);
            this.mTexture = GL12C.glGenTextures();
            GlStateManager._bindTexture((int)this.mTexture);
            GL12C.glTexParameteri((int)3553, (int)33082, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33083, (int)maxLevel);
            GL12C.glTexParameteri((int)3553, (int)33084, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33085, (int)maxLevel);
            GL12C.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            for (int level = 0; level <= maxLevel; ++level) {
                GL12C.glTexImage2D((int)3553, (int)level, (int)32856, (int)(this.mWidth >> level), (int)(this.mHeight >> level), (int)0, (int)6403, (int)5121, (IntBuffer)null);
            }
            GL12C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL12C.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL12C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL12C.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL12C.glPixelStorei((int)3314, (int)0);
            GL12C.glPixelStorei((int)3316, (int)0);
            GL12C.glPixelStorei((int)3315, (int)0);
            GL12C.glPixelStorei((int)3317, (int)1);
            try (class_1011 class_10112 = image;){
                GL12C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)6408, (int)5121, (long)image.field_4988);
            }
            GL30C.glGenerateMipmap((int)3553);
            this.mGpuTexture = new class_10868("Slide STA", TextureFormat.RGBA8, this.mWidth, this.mHeight, 1, this.mTexture);
            this.mRenderType = new SlideRenderType(this.mGpuTexture);
        }
        catch (Throwable t) {
            this.close();
            throw new CompletionException(t);
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    @Override
    @NotNull
    public SlideRenderType updateAndGet(long tick, float partialTick) {
        return this.mRenderType;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public void close() {
        if (this.mTexture != 0) {
            GlStateManager._deleteTexture((int)this.mTexture);
        }
        this.mTexture = 0;
        this.mGpuTexture.close();
    }

    public static class_1011 createNativeImage(@Nullable class_1011.class_1012 format, ByteBuffer buffer) throws IOException {
        if (format != null && !format.method_4338()) {
            throw new UnsupportedOperationException("Don't know how to read format " + String.valueOf(format));
        }
        if (MemoryUtil.memAddress((ByteBuffer)buffer) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            IntBuffer intBuffer2 = memoryStack.mallocInt(1);
            IntBuffer intBuffer3 = memoryStack.mallocInt(1);
            ByteBuffer byteBuffer = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)intBuffer, (IntBuffer)intBuffer2, (IntBuffer)intBuffer3, (int)(format == null ? 0 : format.method_4335()));
            if (byteBuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            class_1011 class_10112 = new class_1011(format == null ? class_1011.class_1012.method_4336((int)intBuffer3.get(0)) : format, intBuffer.get(0), intBuffer2.get(0), true, MemoryUtil.memAddress((ByteBuffer)byteBuffer));
            return class_10112;
        }
    }
}

