/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.RegistryClient;
import org.teacon.slides.util.Utilities;

public final class ProjectorAfterUpdateC2SPacket {
    private final class_2338 mPos;
    private final ProjectorBlock.InternalRotation mRotation;
    private final class_2487 mTag;
    private final boolean mBoolean;

    public ProjectorAfterUpdateC2SPacket(ProjectorBlockEntity entity, ProjectorBlock.InternalRotation rotation) {
        this.mPos = entity.method_11016();
        this.mRotation = rotation;
        this.mTag = new class_2487();
        entity.saveCompound(this.mTag);
        this.mBoolean = entity.needInitContainer;
    }

    public ProjectorAfterUpdateC2SPacket(class_2540 buf) {
        this.mPos = buf.method_10811();
        this.mRotation = ProjectorBlock.InternalRotation.VALUES[buf.method_10816()];
        this.mTag = buf.method_10798();
        this.mBoolean = buf.readBoolean();
    }

    public void sendToServer() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10807(this.mPos);
        buffer.method_10804(this.mRotation.ordinal());
        buffer.method_10794((class_2520)this.mTag);
        buffer.method_52964(this.mBoolean);
        RegistryClient.sendToServer(Slideshow.PACKET_UPDATE, buffer);
    }

    public static void handle(MinecraftServer minecraftServer, class_3222 player, class_2540 packet) {
        ProjectorAfterUpdateC2SPacket projectorAfterUpdatePacket = new ProjectorAfterUpdateC2SPacket(packet);
        minecraftServer.execute(() -> {
            class_3218 level = player.method_51469();
            class_2338 pos = projectorAfterUpdatePacket.mPos;
            class_2586 blockEntity = level.method_8321(pos);
            if (ProjectorBlock.hasProjectorPermission(player) && level.method_8477(pos) && blockEntity instanceof ProjectorBlockEntity) {
                ProjectorBlockEntity blockEntity1 = (ProjectorBlockEntity)blockEntity;
                class_2680 state = (class_2680)blockEntity.method_11010().method_11657(ProjectorBlock.ROTATION, (Comparable)((Object)projectorAfterUpdatePacket.mRotation));
                blockEntity1.loadCompound(projectorAfterUpdatePacket.mTag);
                blockEntity1.needInitContainer = projectorAfterUpdatePacket.mBoolean;
                blockEntity.method_5431();
                if (!level.method_8652(pos, state, 3)) {
                    level.method_8413(pos, state, state, 2);
                }
                return;
            }
            GameProfile profile = player.method_7334();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector update: player = {}, pos = {}", (Object)profile, (Object)projectorAfterUpdatePacket.mPos);
        });
    }
}

