/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.luciad.imageio.webp.WebPReadParam;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.class_1011;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

public final class WebPDecoder {
    public static boolean checkMagic(byte @NotNull [] buf) {
        if (buf.length >= 12) {
            ByteBuffer wr = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
            boolean riff = wr.getInt() == 1179011410;
            boolean size = wr.getInt() == buf.length - 8;
            boolean webp = wr.getInt() == 1346520407;
            boolean vp8_ = ArrayUtils.contains((int[])new int[]{1480085590, 1278758998, 540561494}, (int)wr.getInt());
            return riff && size && webp && vp8_;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static class_1011 toNativeImage(byte @NotNull [] buf) {
        int[] rgbaSwizzle = new int[]{6403, 6404, 6405, 6406};
        try (ByteArrayInputStream stream = new ByteArrayInputStream(buf);){
            class_1011 class_10112;
            block33: {
                ImageInputStream imageStream = ImageIO.createImageInputStream(stream);
                try {
                    WebPReadParam readParam = new WebPReadParam();
                    readParam.setBypassFiltering(true);
                    ImageReader reader = ImageIO.getImageReadersByMIMEType("image/webp").next();
                    reader.setInput(imageStream);
                    BufferedImage image = reader.read(0, readParam);
                    ColorModel colorModel = image.getColorModel();
                    if (!(colorModel instanceof DirectColorModel)) {
                        Class<?> colorModelType = image.getColorModel().getClass();
                        throw new IOException("unrecognized color model type: " + colorModelType.getName());
                    }
                    DirectColorModel imageColorModel = (DirectColorModel)colorModel;
                    boolean bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
                    for (int i = 0; i < rgbaSwizzle.length; ++i) {
                        int mask = switch (i) {
                            case 0 -> imageColorModel.getRedMask();
                            case 1 -> imageColorModel.getGreenMask();
                            case 2 -> imageColorModel.getBlueMask();
                            case 3 -> imageColorModel.getAlphaMask();
                            default -> 0;
                        };
                        rgbaSwizzle[i] = switch (mask) {
                            case 0 -> 0;
                            case -16777216 -> {
                                if (bigEndian) {
                                    yield 6403;
                                }
                                yield 6406;
                            }
                            case 0xFF0000 -> {
                                if (bigEndian) {
                                    yield 6404;
                                }
                                yield 6405;
                            }
                            case 65280 -> {
                                if (bigEndian) {
                                    yield 6405;
                                }
                                yield 6404;
                            }
                            case 255 -> {
                                if (bigEndian) {
                                    yield 6406;
                                }
                                yield 6403;
                            }
                            default -> throw new IOException("unrecognized rgba mask[%d]: 0x%08X".formatted(i, mask));
                        };
                    }
                    DataBuffer mask = image.getData().getDataBuffer();
                    if (!(mask instanceof DataBufferInt)) {
                        Class<?> bufferType = image.getData().getDataBuffer().getClass();
                        throw new IOException("unrecognized data buffer type: " + bufferType.getName());
                    }
                    DataBufferInt imageDataBuffer = (DataBufferInt)mask;
                    class_1011 nativeImage = new class_1011(image.getWidth(), image.getHeight(), false);
                    int size = image.getWidth() * image.getHeight() * 4;
                    ByteBuffer nativeBuffer = MemoryUtil.memByteBuffer((long)nativeImage.field_4988, (int)Math.toIntExact(size));
                    Objects.requireNonNull(nativeBuffer).asIntBuffer().put(imageDataBuffer.getData());
                    class_10112 = nativeImage;
                    if (imageStream == null) break block33;
                }
                catch (Throwable throwable) {
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                imageStream.close();
            }
            return class_10112;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

