/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.teacon.slides.SlideshowClient;
import org.teacon.slides.command.ImageCommand;
import org.teacon.slides.command.ImageinfoCommand;
import org.teacon.slides.command.ProjectorCommand;
import org.teacon.slides.command.UnsignedMessageArgumentType;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.item.ImageItem;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;

@Mod(value="slideshow")
public class Slideshow {
    public static final String ID = "slide_show";
    public static final Logger LOGGER = LogManager.getLogger((String)"slide_show");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"slide_show");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"slide_show");
    public static final DeferredRegister<BlockEntityType<?>> BLOCKS_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"slide_show");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"slide_show");
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"slide_show");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"slide_show");
    public static final DeferredItem<Item> IMAGE_ITEM = ITEMS.register("image", () -> new ImageItem(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"image")))));
    public static final DeferredItem<Item> FLIPPER_ITEM = ITEMS.register("flipper", () -> new FlipperItem(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"flipper")))));
    public static final DeferredBlock<Block> PROJECTOR_BLOCK = BLOCKS.register("projector", () -> new ProjectorBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(20.0f).lightLevel(state -> 15).noCollission().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"projector")))));
    public static final DeferredItem<BlockItem> PROJECTOR_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("projector", PROJECTOR_BLOCK, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"projector"))));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ProjectorBlockEntity>> PROJECTOR_BLOCK_ENTITY = BLOCKS_ENTITY_TYPES.register("projector", () -> new BlockEntityType(ProjectorBlockEntity::new, new Block[]{(Block)PROJECTOR_BLOCK.get()}));
    public static final DeferredHolder<MenuType<?>, MenuType<ProjectorScreenHandler>> PROJECTOR_SCREEN_HANDLER = MENUS.register("projector_screen_handler", ProjectorScreenHandler::create);
    public static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<UnsignedMessageArgumentType>> UMA_INFO = ARGUMENT_TYPES.register("unsigned_message", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(UnsignedMessageArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(UnsignedMessageArgumentType::message)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Integer>>> PROJECTOR_COMPONENT = DATA_COMPONENT_TYPES.register("projector", () -> DataComponentType.builder().persistent(Codec.INT.listOf(3, 3)).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> FROM_ID_COMPONENT = DATA_COMPONENT_TYPES.register("from_id", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> LOCATION_COMPONENT = DATA_COMPONENT_TYPES.register("location", () -> DataComponentType.builder().persistent((Codec)Codec.STRING).build());

    public Slideshow(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCKS_ENTITY_TYPES.register(modEventBus);
        MENUS.register(modEventBus);
        ARGUMENT_TYPES.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            modEventBus.addListener(SlideshowClient::registerRenders);
            modEventBus.addListener(SlideshowClient::setupClient);
            modEventBus.addListener(SlideshowClient::onRegisterReloadListeners);
            modEventBus.addListener(SlideshowClient::onRegisterMenu);
            NeoForge.EVENT_BUS.addListener(SlideshowClient::onClientTick);
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
    }

    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(IMAGE_ITEM);
            event.accept(FLIPPER_ITEM);
            event.accept(PROJECTOR_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is((Item)FLIPPER_ITEM.get())) {
            FlipperItem.appendHoverText(stack, event.getToolTip());
        } else if (stack.is((Item)IMAGE_ITEM.get())) {
            ImageItem.appendHoverText(stack, event.getToolTip());
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ImageCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ProjectorCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ImageinfoCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

