/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.FlipperFlipBackC2SPayload;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Utilities;

public class FlipperItem
extends Item {
    private static boolean attackKeyDown = false;

    public FlipperItem(Item.Properties properties) {
        super(properties);
    }

    public static List<Integer> getProjectorPos(ItemStack stack) {
        if (!stack.is(Slideshow.FLIPPER_ITEM)) {
            return null;
        }
        List intArray = (List)stack.get(Slideshow.PROJECTOR_COMPONENT);
        if (intArray == null || intArray.size() < 3) {
            return null;
        }
        return intArray;
    }

    public static void setProjectorPos(ItemStack stack, @Nullable BlockPos pos) {
        if (!stack.is(Slideshow.FLIPPER_ITEM)) {
            return;
        }
        if (pos == null) {
            stack.remove(Slideshow.PROJECTOR_COMPONENT);
            return;
        }
        stack.set(Slideshow.PROJECTOR_COMPONENT, Arrays.asList(pos.getX(), pos.getY(), pos.getZ()));
    }

    public static boolean trySendFlip(Level world, ServerPlayer player, ItemStack itemStack, boolean back, boolean init) {
        List<Integer> pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            Utilities.sendOverLayMessage((Player)player, (Component)Component.translatable((String)"info.slide_show.need_bound").withStyle(ChatFormatting.DARK_RED));
            return false;
        }
        BlockEntity entity = world.getBlockEntity(new BlockPos(pos.get(0).intValue(), pos.get(1).intValue(), pos.get(2).intValue()));
        if (!(entity instanceof ProjectorBlockEntity)) {
            Utilities.sendOverLayMessage((Player)player, (Component)Component.translatable((String)"info.slide_show.binding_lost").withStyle(ChatFormatting.DARK_RED));
            FlipperItem.setProjectorPos(itemStack, null);
            return false;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!FlipperItem.hasFlipperPermission(player)) {
            return false;
        }
        if (!entity1.canFlip()) {
            return false;
        }
        if (init) {
            entity1.needInitContainer = true;
            Utilities.sendOverLayMessage((Player)player, (Component)Component.translatable((String)"info.slide_show.initialized").withStyle(ChatFormatting.AQUA));
            return true;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        Utilities.sendOverLayMessage((Player)player, (Component)Component.translatable((String)"info.slide_show.slide_flipped").withStyle(ChatFormatting.AQUA));
        return true;
    }

    private static boolean hasFlipperPermission(ServerPlayer player) {
        return player.isCreative() || player.gameMode.getGameModeForPlayer() == GameType.SURVIVAL;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (FlipperItem.trySendFlip(world, (ServerPlayer)user, itemStack, false, user.isShiftKeyDown())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getItemInHand();
        if (stack.is(Slideshow.FLIPPER_ITEM)) {
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (player == null) {
                return InteractionResult.FAIL;
            }
            if (world.getBlockEntity(pos) instanceof ProjectorBlockEntity) {
                FlipperItem.setProjectorPos(stack, pos);
                Utilities.sendOverLayMessage(player, (Component)Component.translatable((String)"info.slide_show.bound_projector").withStyle(ChatFormatting.AQUA));
                return InteractionResult.CONSUME;
            }
            return FlipperItem.trySendFlip(world, (ServerPlayer)player, stack, false, player.isShiftKeyDown()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static void clientPlayerTick(Player player) {
        if (player.getMainHandItem().is(Slideshow.FLIPPER_ITEM) && attackKeyDown != Minecraft.getInstance().options.keyAttack.isDown()) {
            boolean bl = attackKeyDown = !attackKeyDown;
            if (attackKeyDown) {
                FlipperItem.sendServerFlipBack();
            }
        }
    }

    public static void appendHoverText(ItemStack itemStack, List<Component> list) {
        List<Integer> pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            list.add((Component)Component.translatable((String)"item.slide_show.flipper.tooltip.not_bound").withStyle(ChatFormatting.RED));
            list.add((Component)Component.translatable((String)"item.slide_show.flipper.tooltip.not_bound1"));
            return;
        }
        list.add((Component)Component.translatable((String)"item.slide_show.flipper.tooltip.bound", (Object[])new Object[]{pos.get(0), pos.get(1), pos.get(2)}).withStyle(ChatFormatting.AQUA));
    }

    private static void sendServerFlipBack() {
        PacketDistributor.sendToServer((CustomPacketPayload)new FlipperFlipBackC2SPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean canDestroyBlock(ItemStack stack, BlockState state, Level level, BlockPos pos, LivingEntity entity) {
        return false;
    }
}

