/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.network.Network;
import org.teacon.slides.util.Utilities;

public final class FlipperFlipBackC2SPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FlipperFlipBackC2SPayload> ID = new CustomPacketPayload.Type(Network.PACKET_FLIP_BACK);

    public FlipperFlipBackC2SPayload() {
    }

    public FlipperFlipBackC2SPayload(RegistryFriendlyByteBuf buf) {
    }

    public static void writeBuffer(FlipperFlipBackC2SPayload payload, RegistryFriendlyByteBuf buffer) {
    }

    public static void handle(FlipperFlipBackC2SPayload payload, IPayloadContext context) {
        ServerPlayer serverPlayer = (ServerPlayer)context.player();
        context.enqueueWork(() -> {
            ItemStack itemStack = serverPlayer.getMainHandItem();
            if (itemStack.is(Slideshow.FLIPPER_ITEM) && FlipperItem.trySendFlip((Level)serverPlayer.serverLevel(), serverPlayer, itemStack, true, false)) {
                return;
            }
            GameProfile profile = serverPlayer.getGameProfile();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for flip back: player = {}", (Object)profile);
        });
    }

    public CustomPacketPayload.Type<FlipperFlipBackC2SPayload> type() {
        return ID;
    }
}

