/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.cache.ImageCache;
import org.teacon.slides.renderer.Slide;
import org.teacon.slides.texture.AnimatedTextureProvider;
import org.teacon.slides.texture.GIFDecoder;
import org.teacon.slides.texture.StaticTextureProvider;
import org.teacon.slides.texture.TextureProvider;
import org.teacon.slides.texture.WebPDecoder;
import org.teacon.slides.util.RenderTaskManager;

@OnlyIn(value=Dist.CLIENT)
public final class SlideState {
    private static final Executor RENDER_EXECUTOR = r -> RenderTaskManager.recordRenderCall(r::run);
    private static final int RECYCLE_SECONDS = 120;
    private static final int RETRY_INTERVAL_SECONDS = 30;
    private static long sAnimationTick;
    private static final int CLEANER_INTERVAL_SECONDS = 720;
    private static int sCleanerTimer;
    private static final AtomicReference<ConcurrentHashMap<String, SlideState>> sCache;
    private static final AtomicReference<ConcurrentHashMap<String, SlideState>> sCacheID;
    private Slide mSlide;
    private State mState;
    private int mCounter;

    public static void clearCacheID() {
        sCacheID.getAcquire().clear();
    }

    public static void tick(Minecraft client) {
        if (!client.isPaused() && ++sAnimationTick % 20L == 0L) {
            ConcurrentHashMap<String, SlideState> map = sCache.getAcquire();
            if (!map.isEmpty()) {
                map.entrySet().removeIf(entry -> ((SlideState)entry.getValue()).update());
            }
            if (!(map = sCacheID.getAcquire()).isEmpty()) {
                map.entrySet().removeIf(entry -> ((SlideState)entry.getValue()).update());
            }
            if (++sCleanerTimer > 720) {
                int n = ImageCache.getInstance().cleanResources();
                if (n != 0) {
                    Slideshow.LOGGER.debug("Cleanup {} http cache image resources", (Object)n);
                }
                sCleanerTimer = 0;
            }
        }
    }

    public static void onPlayerLeft(Minecraft minecraft) {
        RenderTaskManager.recordRenderCall(() -> {
            ConcurrentHashMap map = sCache.getAndSet(new ConcurrentHashMap());
            int size = map.size();
            map.values().forEach(s -> s.mSlide.close());
            map.clear();
            map = sCacheID.getAndSet(new ConcurrentHashMap());
            map.values().forEach(s -> s.mSlide.close());
            Slideshow.LOGGER.debug("Release {} slide images", (Object)(size += map.size()));
            map.clear();
        });
    }

    public static long getAnimationTick() {
        return sAnimationTick;
    }

    @Nullable
    public static Slide getSlide(String location, boolean fromID) {
        if (location == null || location.isEmpty()) {
            return null;
        }
        if (fromID) {
            return sCacheID.getAcquire().computeIfAbsent(location, SlideState::getSlideStateFromID).getWithUpdate();
        }
        return sCache.getAcquire().computeIfAbsent(location, SlideState::new).getWithUpdate();
    }

    public static void cacheSlide(String location, boolean fromID) {
        if (location == null || location.isEmpty()) {
            return;
        }
        if (fromID) {
            sCacheID.getAcquire().computeIfAbsent(location, SlideState::getSlideStateFromID);
            return;
        }
        sCache.getAcquire().computeIfAbsent(location, SlideState::new);
    }

    private SlideState() {
    }

    @NotNull
    private static SlideState getSlideStateFromID(String location) {
        SlideState s = new SlideState();
        ResourceLocation ID = ResourceLocation.tryParse((String)location);
        if (ID == null) {
            s.mSlide = Slide.empty();
            s.mState = State.FAILED_OR_EMPTY;
            s.mCounter = 30;
        } else {
            s.mSlide = Slide.loading();
            s.mState = State.LOADING;
            s.mCounter = 120;
            ((CompletableFuture)((CompletableFuture)ImageCache.getInstance().getResourceFromPack(ID).thenCompose(data -> SlideState.createTexture(location, data))).thenAccept(textureProvider -> {
                if (s.mState == State.LOADING) {
                    s.mSlide = Slide.make(textureProvider);
                    s.mState = State.LOADED;
                } else {
                    assert (s.mState == State.LOADED);
                    textureProvider.close();
                }
            })).exceptionally(e -> {
                RenderTaskManager.recordRenderCall(() -> {
                    assert (s.mState == State.LOADING);
                    s.mSlide = Slide.failed();
                    s.mState = State.FAILED_OR_EMPTY;
                    s.mCounter = 30;
                });
                return null;
            });
        }
        return s;
    }

    private SlideState(String location) {
        URI uri = SlideState.createURI(location);
        if (uri == null) {
            this.mSlide = Slide.empty();
            this.mState = State.FAILED_OR_EMPTY;
            this.mCounter = 30;
        } else {
            this.mSlide = Slide.loading();
            this.mState = State.LOADING;
            this.mCounter = 120;
            ((CompletableFuture)((CompletableFuture)ImageCache.getInstance().getResource(uri, true).thenCompose(data -> SlideState.createTexture(location, data))).thenAccept(textureProvider -> {
                if (this.mState == State.LOADING) {
                    this.mSlide = Slide.make(textureProvider);
                    this.mState = State.LOADED;
                } else {
                    assert (this.mState == State.LOADED);
                    textureProvider.close();
                }
            })).exceptionally(e -> {
                RenderTaskManager.recordRenderCall(() -> {
                    assert (this.mState == State.LOADING);
                    this.mSlide = Slide.failed();
                    this.mState = State.FAILED_OR_EMPTY;
                    this.mCounter = 30;
                });
                return null;
            });
        }
    }

    @NotNull
    private Slide getWithUpdate() {
        if (this.mState != State.FAILED_OR_EMPTY) {
            this.mCounter = 120;
        }
        return this.mSlide;
    }

    private boolean update() {
        if (--this.mCounter < 0) {
            RenderTaskManager.recordRenderCall(() -> {
                if (this.mState == State.LOADED) {
                    assert (this.mSlide instanceof Slide.Image);
                    this.mSlide.close();
                } else if (this.mState == State.LOADING) {
                    assert (this.mSlide == Slide.loading());
                    this.mState = State.LOADED;
                } else {
                    assert (this.mSlide instanceof Slide.Icon);
                    assert (this.mState == State.FAILED_OR_EMPTY);
                }
            });
            return true;
        }
        return false;
    }

    public String toString() {
        return "SlideState{slide=" + String.valueOf(this.mSlide) + ", state=" + String.valueOf((Object)this.mState) + ", counter=" + this.mCounter + "}";
    }

    private static CompletableFuture<TextureProvider> createTexture(String name, byte[] data) {
        boolean isGif = name.endsWith(".gif") || GIFDecoder.checkMagic(data);
        boolean isWebP = name.endsWith(".webp") || WebPDecoder.checkMagic(data);
        return CompletableFuture.supplyAsync(isGif ? () -> new AnimatedTextureProvider(data) : () -> new StaticTextureProvider(data, isWebP), RENDER_EXECUTOR);
    }

    @Nullable
    public static URI createURI(String location) {
        if (StringUtils.isNotBlank((CharSequence)location)) {
            try {
                return URI.create(location);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static {
        sCache = new AtomicReference(new ConcurrentHashMap());
        sCacheID = new AtomicReference(new ConcurrentHashMap());
    }

    public static enum State {
        NOTHING,
        LOADING,
        LOADED,
        FAILED_OR_EMPTY;

    }
}

