/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2481;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.util.RegistryClient;
import org.teacon.slides.util.Utilities;

public class ProjectorExportC2SPacket {
    private final boolean mFromID;
    private final String mLocation;

    public ProjectorExportC2SPacket(boolean fromID, String location) {
        this.mFromID = fromID;
        this.mLocation = location;
    }

    public ProjectorExportC2SPacket(class_2540 buf) {
        this.mFromID = buf.readBoolean();
        this.mLocation = buf.method_19772();
    }

    public void sendToServer() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeBoolean(this.mFromID);
        buffer.method_10814(this.mLocation);
        RegistryClient.sendToServer(Slideshow.PACKET_EXPORT, buffer);
    }

    public static void handle(MinecraftServer minecraftServer, class_3222 serverPlayer, class_2540 packet) {
        ProjectorExportC2SPacket projectorExportPacket = new ProjectorExportC2SPacket(packet);
        minecraftServer.execute(() -> {
            if (ProjectorExportC2SPacket.giveImageItem(serverPlayer, projectorExportPacket.mFromID, projectorExportPacket.mLocation)) {
                return;
            }
            GameProfile profile = serverPlayer.method_7334();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
        });
    }

    public static boolean giveImageItem(class_3222 serverPlayer, boolean fromID, String location) {
        if (ProjectorBlock.hasProjectorPermission(serverPlayer)) {
            class_1799 itemStack = new class_1799((class_1935)Slideshow.IMAGE_ITEM, 1);
            itemStack.method_7959("from_id", (class_2520)class_2481.method_23234((boolean)fromID));
            itemStack.method_7959("location", (class_2520)class_2519.method_23256((String)location));
            boolean bl = serverPlayer.method_31548().method_7394(itemStack);
            if (bl && itemStack.method_7960()) {
                itemStack.method_7939(1);
                class_1542 itemEntity = serverPlayer.method_7328(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.method_6987();
                }
                serverPlayer.field_6002.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverPlayer.method_6051().method_43057() - serverPlayer.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.field_7498.method_7623();
            } else {
                class_1542 itemEntity = serverPlayer.method_7328(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.method_6975();
                    itemEntity.method_6984(serverPlayer.method_5667());
                }
            }
            return true;
        }
        return false;
    }
}

