/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.teacon.slides.Slideshow;
import org.teacon.slides.util.Utilities;

public class ServerConfig {
    private static boolean initialized = false;
    private static Path CONFIG_PATH;
    private static int projectorPermission;
    private static boolean projectorRequiresCreative;
    private static int commandsPermission;
    private static final String PROJECTOR_PERMISSION = "projectorPermission";
    private static final String PROJECTOR_REQUIRES_CREATIVE = "projectorRequiresCreative";
    private static final String COMMANDS_PERMISSION = "commandsPermission";

    public static void init(MinecraftServer server) {
        if (!initialized) {
            try {
                CONFIG_PATH = server.method_27050(class_5218.field_24188).resolve("config").resolve("slideshow.json");
                initialized = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void uninit() {
        initialized = false;
        projectorPermission = 2;
        projectorRequiresCreative = true;
        commandsPermission = 2;
    }

    public static int getProjectorPermission() {
        return projectorPermission;
    }

    public static boolean isProjectorRequiresCreative() {
        return projectorRequiresCreative;
    }

    public static int getCommandsPermission() {
        return commandsPermission;
    }

    public static void refreshProperties() {
        if (!initialized) {
            return;
        }
        Slideshow.LOGGER.info("Refreshed Slideshow server config");
        try {
            JsonObject jsonConfig = JsonParser.parseString((String)String.join((CharSequence)"", Files.readAllLines(CONFIG_PATH))).getAsJsonObject();
            try {
                projectorPermission = jsonConfig.get(PROJECTOR_PERMISSION).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                projectorRequiresCreative = jsonConfig.get(PROJECTOR_REQUIRES_CREATIVE).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                commandsPermission = jsonConfig.get(COMMANDS_PERMISSION).getAsInt();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            ServerConfig.writeToFile();
            ServerConfig.refreshProperties();
        }
    }

    private static void writeToFile() {
        Slideshow.LOGGER.info("Wrote Slideshow server config to file");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty(PROJECTOR_PERMISSION, (Number)projectorPermission);
        jsonConfig.addProperty(PROJECTOR_REQUIRES_CREATIVE, Boolean.valueOf(projectorRequiresCreative));
        jsonConfig.addProperty(COMMANDS_PERMISSION, (Number)commandsPermission);
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            Files.write(CONFIG_PATH, Collections.singleton(Utilities.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (IOException e) {
            Slideshow.LOGGER.error("Configuration file write exception", (Throwable)e);
        }
    }

    static {
        projectorPermission = 2;
        projectorRequiresCreative = true;
        commandsPermission = 2;
    }
}

