/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4581;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.ProjectorImageInfoS2CPacket;
import org.teacon.slides.projector.ImageProperties;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;

public final class ProjectorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    public SourceType mSourceType = SourceType.URL;
    public String mLocation = "";
    public int mColor = -1;
    public List<ImageProperties> imageProps = new ArrayList<ImageProperties>();
    public boolean mDoubleSided = true;
    public class_1263 mContainer = null;
    public int scanIndex = -1;
    public boolean needInitContainer = false;
    public boolean needHandleReadImage = false;
    public boolean flipBack = false;
    public boolean mCFromID = false;
    public String mCLocation = "";
    public boolean mCNextFromID = false;
    public String mCNextLocation = "";

    public ProjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(Slideshow.PROJECTOR_BLOCK_ENTITY, pos, state);
        this.imageProps.add(new ImageProperties());
    }

    public void transformToSlideSpace(class_1159 pose, class_4581 normal, ImageProperties prop) {
        class_2680 state = this.method_11010();
        pose.method_31544(0.5f, 0.5f, 0.5f);
        class_1158 quaternion = prop.anglesUseDefault ? ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_23224() : prop.getRotation();
        pose.method_22670(quaternion);
        normal.method_23274(quaternion);
        pose.method_31544(0.0f, 0.5f, 0.0f);
        ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.method_11654(ProjectorBlock.ROTATION));
        rotation.transform(pose);
        rotation.transform(normal);
        pose.method_31544(-0.5f, 0.0f, 0.5f - prop.height);
        pose.method_31544(prop.offsetX, -prop.offsetZ, prop.offsetY);
        pose.method_22672(class_1159.method_24019((float)prop.width, (float)1.0f, (float)prop.height));
    }

    private boolean tryReadImageItem(class_1799 item, boolean next) {
        if (item.method_31574(Slideshow.IMAGE_ITEM) && item.method_7985() && item.method_7969().method_10545("location")) {
            if (next) {
                this.mCNextFromID = item.method_7969().method_10577("from_id");
                this.mCNextLocation = item.method_7969().method_10558("location");
            } else {
                this.mCFromID = item.method_7969().method_10577("from_id");
                this.mCLocation = item.method_7969().method_10558("location");
            }
            return true;
        }
        return false;
    }

    private void handleReadImage(boolean back) {
        class_1799 item;
        int i;
        int j;
        int size = this.mContainer.method_5439();
        if (size <= 0) {
            return;
        }
        int start = back ? size + this.scanIndex - 1 : this.scanIndex + 1;
        int end = back ? this.scanIndex - 1 : size + this.scanIndex + 1;
        boolean found = false;
        if (back) {
            for (j = start; j > end; --j) {
                i = j % size;
                item = this.mContainer.method_5438(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        } else {
            for (j = start; j < end; ++j) {
                i = j % size;
                item = this.mContainer.method_5438(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        }
        if (!found) {
            this.mCNextLocation = "";
            return;
        }
        for (j = start; j < end; ++j) {
            i = j % size;
            item = this.mContainer.method_5438(i);
            if (!this.tryReadImageItem(item, true)) continue;
            return;
        }
    }

    public boolean canFlip() {
        return this.mSourceType == SourceType.ContainerBlock && this.mContainer != null;
    }

    public boolean getFromID() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mSourceType == SourceType.ResourceID;
        }
        return this.mCFromID;
    }

    public String getLocation() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mLocation;
        }
        return this.mCLocation;
    }

    public void updateProps(List<ImageProperties> props) {
        this.imageProps = new ArrayList<ImageProperties>(props);
    }

    public void method_11007(class_2487 compoundTag) {
        this.saveCompound(compoundTag);
        super.method_11007(compoundTag);
    }

    public void method_11014(class_2487 compoundTag) {
        this.loadCompound(compoundTag);
        super.method_11014(compoundTag);
    }

    public void saveCompound(class_2487 compoundTag) {
        compoundTag.method_10582("SourceType", switch (this.mSourceType) {
            case SourceType.ResourceID -> "resource_id";
            case SourceType.ContainerBlock -> "container";
            default -> "url";
        });
        compoundTag.method_10582("ImageLocation", this.mLocation);
        compoundTag.method_10569("Color", this.mColor);
        class_2499 list = new class_2499();
        this.imageProps.forEach(imageProp -> list.add((Object)imageProp.getNbt()));
        compoundTag.method_10566("ImageProps", (class_2520)list);
        compoundTag.method_10556("DoubleSided", this.mDoubleSided);
        compoundTag.method_10569("ScanIndex", this.scanIndex);
        compoundTag.method_10556("CFromID", this.mCFromID);
        compoundTag.method_10582("CLocation", this.mCLocation);
        compoundTag.method_10556("CNextFromID", this.mCNextFromID);
        compoundTag.method_10582("CNextLocation", this.mCNextLocation);
    }

    public void loadCompound(class_2487 compoundTag) {
        this.mSourceType = switch (compoundTag.method_10558("SourceType")) {
            case "resource_id" -> SourceType.ResourceID;
            case "container" -> SourceType.ContainerBlock;
            default -> SourceType.URL;
        };
        this.mLocation = compoundTag.method_10558("ImageLocation");
        this.mColor = compoundTag.method_10550("Color");
        this.imageProps = new ArrayList<ImageProperties>();
        if (compoundTag.method_10545("ImageProps")) {
            class_2499 nbtList = compoundTag.method_10554("ImageProps", 10);
            nbtList.forEach(nbt -> {
                if (nbt instanceof class_2487) {
                    class_2487 compound = (class_2487)nbt;
                    this.imageProps.add(new ImageProperties(compound));
                }
            });
            if (this.imageProps.isEmpty()) {
                this.imageProps.add(new ImageProperties());
            }
        } else {
            this.imageProps.add(new ImageProperties());
        }
        this.mDoubleSided = compoundTag.method_10577("DoubleSided");
        this.scanIndex = compoundTag.method_10550("ScanIndex");
        this.mCFromID = compoundTag.method_10577("CFromID");
        this.mCLocation = compoundTag.method_10558("CLocation");
        this.mCNextFromID = compoundTag.method_10577("CNextFromID");
        this.mCNextLocation = compoundTag.method_10558("CNextLocation");
    }

    public void sync() {
        new ProjectorImageInfoS2CPacket(this).sendToClient((class_3218)this.field_11863);
    }

    public static void tick(class_1937 world, class_2338 pos, ProjectorBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        if (entity.mSourceType != SourceType.ContainerBlock) {
            return;
        }
        entity.mContainer = class_2614.method_11250((class_1937)world, (class_2338)ProjectorBlockEntity.tryParseCoor(entity.mLocation, pos));
        if (entity.mContainer == null) {
            entity.mCLocation = "";
            entity.mCNextLocation = "";
            entity.scanIndex = -1;
            return;
        }
        if (entity.needInitContainer) {
            entity.scanIndex = -1;
            entity.handleReadImage(false);
            entity.needInitContainer = false;
            entity.method_5431();
            entity.sync();
            return;
        }
        if (entity.needHandleReadImage) {
            if (entity.scanIndex < 0) {
                entity.scanIndex = -1;
                entity.handleReadImage(false);
                return;
            }
            entity.handleReadImage(entity.flipBack);
            entity.method_5431();
            entity.sync();
            entity.needHandleReadImage = false;
            entity.flipBack = false;
        }
    }

    private static class_2338 tryParseCoor(String coor, class_2338 pos) {
        try {
            String[] xyz = coor.split("\\s+");
            int[] nPos = new int[3];
            String x = xyz[0];
            nPos[0] = x.startsWith("~") ? pos.method_10263() + ProjectorBlockEntity.parseInt(x.substring(1)) : ProjectorBlockEntity.parseInt(x);
            String y = xyz[1];
            nPos[1] = y.startsWith("~") ? pos.method_10264() + ProjectorBlockEntity.parseInt(y.substring(1)) : ProjectorBlockEntity.parseInt(y);
            String z = xyz[2];
            nPos[2] = z.startsWith("~") ? pos.method_10260() + ProjectorBlockEntity.parseInt(z.substring(1)) : ProjectorBlockEntity.parseInt(z);
            return new class_2338(nPos[0], nPos[1], nPos[2]);
        }
        catch (Exception e) {
            return pos.method_10074();
        }
    }

    private static int parseInt(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public boolean method_11011() {
        return true;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(this.field_11867);
        return new ProjectorScreenHandler(syncId, buf);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

