/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.teacon.slides.command.ProjectorCommand;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.util.Text;

public class ImageinfoCommand {
    private static final ITextComponent IMAGE_INFO_CHANGED = Text.translatable("chat.slide_show.image_info_changed", new Object[0]);

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"imageinfo").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"id").executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.ResourceID, null))).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.ResourceID, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"url").executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.URL, null))).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.URL, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"container").executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.ContainerBlock, null))).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), SourceType.ContainerBlock, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), null, StringArgumentType.getString((CommandContext)context, (String)"location"))))));
    }

    private static int execute(CommandSource source, BlockPos blockPos, @Nullable SourceType sourceType, @Nullable String location) {
        ServerWorld world = source.func_197023_e();
        if (!world.func_195588_v(blockPos)) {
            return 0;
        }
        TileEntity blockEntity = world.func_175625_s(blockPos);
        if (blockEntity instanceof ProjectorBlockEntity) {
            ProjectorBlockEntity projectorBlockEntity = (ProjectorBlockEntity)blockEntity;
            if (sourceType == null && location == null) {
                return 0;
            }
            if (sourceType != null) {
                projectorBlockEntity.mSourceType = sourceType;
            }
            if (location != null) {
                projectorBlockEntity.mLocation = location;
            }
            projectorBlockEntity.func_70296_d();
            BlockState state = projectorBlockEntity.func_195044_w();
            world.func_184138_a(blockPos, state, state, 2);
            source.func_197030_a(IMAGE_INFO_CHANGED, false);
            return 1;
        }
        source.func_197021_a(ProjectorCommand.NO_PROJECTOR);
        return 0;
    }
}

