/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Text;

public class ProjectorCommand {
    protected static final ITextComponent NO_PROJECTOR = Text.translatable("chat.slide_show.no_projector", new Object[0]);
    private static final ITextComponent CANNOT_FLIP = Text.translatable("chat.slide_show.cannot_flip", new Object[0]);
    private static final ITextComponent INITIALIZED = Text.translatable("chat.slide_show.initialized", new Object[0]);
    private static final ITextComponent FLIPPED = Text.translatable("chat.slide_show.flipped", new Object[0]);

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"projector").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"next").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> ProjectorCommand.executeFlip((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), false, false))))).then(Commands.func_197057_a((String)"prev").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> ProjectorCommand.executeFlip((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), true, false))))).then(Commands.func_197057_a((String)"first").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> ProjectorCommand.executeFlip((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), false, true)))));
    }

    public static int executeFlip(CommandSource source, BlockPos pos, boolean back, boolean init) {
        TileEntity entity = source.func_197023_e().func_175625_s(pos);
        if (!(entity instanceof ProjectorBlockEntity)) {
            source.func_197021_a(NO_PROJECTOR);
            return 0;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!entity1.canFlip()) {
            source.func_197021_a(CANNOT_FLIP);
            return 0;
        }
        if (init) {
            entity1.needInitContainer = true;
            source.func_197030_a(INITIALIZED, false);
            return 1;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        source.func_197030_a(FLIPPED, false);
        return 1;
    }
}

