/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.teacon.slides.network.FlipBackC2SPacket;
import org.teacon.slides.network.Network;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Text;
import org.teacon.slides.util.Utilities;

public class FlipperItem
extends Item {
    private static boolean attackKeyDown = false;

    public FlipperItem(Item.Properties properties) {
        super(properties);
    }

    public static int[] getProjectorPos(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof FlipperItem) || !stack.func_77942_o() || stack.func_77978_p().func_74759_k("projector") == null) {
            return null;
        }
        int[] intArray = stack.func_77978_p().func_74759_k("projector");
        if (intArray == null || intArray.length < 3) {
            return null;
        }
        return intArray;
    }

    public static void setProjectorPos(ItemStack stack, @Nullable BlockPos pos) {
        if (!(stack.func_77973_b() instanceof FlipperItem)) {
            return;
        }
        if (pos == null) {
            stack.func_196083_e("projector");
            return;
        }
        stack.func_77983_a("projector", (INBT)new IntArrayNBT(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
    }

    public static boolean trySendFlip(World world, ServerPlayerEntity player, ItemStack itemStack, boolean back, boolean init) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            Utilities.sendOverLayMessage((PlayerEntity)player, (ITextComponent)Text.translatable("info.slide_show.need_bound", new Object[0]).func_240699_a_(TextFormatting.DARK_RED));
            return false;
        }
        TileEntity entity = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(entity instanceof ProjectorBlockEntity)) {
            Utilities.sendOverLayMessage((PlayerEntity)player, (ITextComponent)Text.translatable("info.slide_show.binding_lost", new Object[0]).func_240699_a_(TextFormatting.DARK_RED));
            FlipperItem.setProjectorPos(itemStack, null);
            return false;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!FlipperItem.hasFlipperPermission(player)) {
            return false;
        }
        if (!entity1.canFlip()) {
            return false;
        }
        if (init) {
            entity1.needInitContainer = true;
            Utilities.sendOverLayMessage((PlayerEntity)player, (ITextComponent)Text.translatable("info.slide_show.initialized", new Object[0]).func_240699_a_(TextFormatting.AQUA));
            return true;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        Utilities.sendOverLayMessage((PlayerEntity)player, (ITextComponent)Text.translatable("info.slide_show.slide_flipped", new Object[0]).func_240699_a_(TextFormatting.AQUA));
        return true;
    }

    private static boolean hasFlipperPermission(ServerPlayerEntity player) {
        return player.func_184812_l_() || player.field_71134_c.func_73081_b() == GameType.SURVIVAL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand interactionHand) {
        ItemStack itemStack = player.func_184586_b(interactionHand);
        if (world.func_201670_d()) {
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
        }
        if (FlipperItem.trySendFlip(world, (ServerPlayerEntity)player, itemStack, false, player.func_225608_bj_())) {
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)true);
        }
        return ActionResult.func_226251_d_((Object)itemStack);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(itemStack, world, entity, slot, selected);
        if (world.func_201670_d() && selected && attackKeyDown != Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            boolean bl = attackKeyDown = !attackKeyDown;
            if (attackKeyDown) {
                FlipperItem.sendServerFlipBack(slot);
            }
        }
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            list.add((ITextComponent)Text.translatable("item.slide_show.flipper.tooltip.not_bound", new Object[0]).func_240699_a_(TextFormatting.RED));
            list.add((ITextComponent)Text.translatable("item.slide_show.flipper.tooltip.not_bound1", new Object[0]));
            super.func_77624_a(itemStack, world, list, tooltipFlag);
            return;
        }
        list.add((ITextComponent)Text.translatable("item.slide_show.flipper.tooltip.bound", pos[0], pos[1], pos[2]).func_240699_a_(TextFormatting.AQUA));
        super.func_77624_a(itemStack, world, list, tooltipFlag);
    }

    private static void sendServerFlipBack(int i) {
        Network.CHANNEL.sendToServer((Object)new FlipBackC2SPacket(i));
    }

    public boolean func_195938_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player) {
        return false;
    }
}

