/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.ImageItem;
import org.teacon.slides.util.Utilities;

public class ImageAfterUpdateC2SPacket {
    private final Hand hand;
    private final boolean fromId;
    private final String location;

    public ImageAfterUpdateC2SPacket(Hand hand, boolean fromId, String location) {
        this.hand = hand;
        this.fromId = fromId;
        this.location = location;
    }

    public ImageAfterUpdateC2SPacket(PacketBuffer buf) {
        this.hand = buf.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        this.fromId = buf.readBoolean();
        this.location = buf.func_150789_c(512);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.hand == Hand.MAIN_HAND);
        buffer.writeBoolean(this.fromId);
        buffer.func_180714_a(this.location);
    }

    public static void handle(ImageAfterUpdateC2SPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            ItemStack itemStack = player.func_184586_b(packet.hand);
            if (itemStack != null && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ImageItem) {
                itemStack.func_77983_a("from_id", (INBT)ByteNBT.func_229672_a_((boolean)packet.fromId));
                itemStack.func_77983_a("location", (INBT)StringNBT.func_229705_a_((String)packet.location));
                return;
            }
            GameProfile profile = player.func_146103_bH();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
        });
    }
}

