/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Utilities;

public final class ProjectorAfterUpdateC2SPacket {
    private final BlockPos mPos;
    private final ProjectorBlock.InternalRotation mRotation;
    private final CompoundNBT mTag;
    private final boolean mBoolean;

    public ProjectorAfterUpdateC2SPacket(ProjectorBlockEntity entity, ProjectorBlock.InternalRotation rotation) {
        this.mPos = entity.func_174877_v();
        this.mRotation = rotation;
        this.mTag = new CompoundNBT();
        entity.saveCompound(this.mTag);
        this.mBoolean = entity.needInitContainer;
    }

    public ProjectorAfterUpdateC2SPacket(PacketBuffer buf) {
        this.mPos = buf.func_179259_c();
        this.mRotation = ProjectorBlock.InternalRotation.VALUES[buf.func_150792_a()];
        this.mTag = buf.func_150793_b();
        this.mBoolean = buf.readBoolean();
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.mPos);
        buffer.func_150787_b(this.mRotation.ordinal());
        buffer.func_150786_a(this.mTag);
        buffer.writeBoolean(this.mBoolean);
    }

    public static void handle(ProjectorAfterUpdateC2SPacket packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player == null) {
            context.get().setPacketHandled(true);
        } else {
            context.get().enqueueWork(() -> {
                ServerWorld level = player.func_71121_q();
                BlockPos pos = packet.mPos;
                TileEntity blockEntity = level.func_175625_s(pos);
                if (ProjectorBlock.hasProjectorPermission(player) && level.func_195588_v(pos) && blockEntity instanceof ProjectorBlockEntity) {
                    ProjectorBlockEntity blockEntity1 = (ProjectorBlockEntity)blockEntity;
                    BlockState state = (BlockState)blockEntity.func_195044_w().func_206870_a(ProjectorBlock.ROTATION, (Comparable)((Object)packet.mRotation));
                    blockEntity1.loadCompound(packet.mTag);
                    blockEntity1.needInitContainer = packet.mBoolean;
                    blockEntity.func_70296_d();
                    if (!level.func_180501_a(pos, state, 3)) {
                        level.func_184138_a(pos, state, state, 2);
                    }
                } else {
                    GameProfile profile = player.func_146103_bH();
                    Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector update: player = {}, pos = {}", (Object)profile, (Object)packet.mPos);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

