/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.util.Text;
import org.teacon.slides.util.Utilities;

public final class ProjectorBlock
extends Block {
    public static final EnumProperty<InternalRotation> ROTATION = EnumProperty.func_177709_a((String)"rotation", InternalRotation.class);
    public static final EnumProperty<Direction> BASE = EnumProperty.func_177708_a((String)"base", Direction.class, (Predicate)Direction.Plane.VERTICAL);
    private static final VoxelShape SHAPE_WITH_BASE_UP = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WITH_BASE_DOWN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ProjectorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(20.0f).func_235838_a_(state -> 15).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(BASE, (Comparable)Direction.DOWN)).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST)).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.FALSE)).func_206870_a(ROTATION, (Comparable)((Object)InternalRotation.NONE)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b(BASE)) {
            case DOWN: {
                return SHAPE_WITH_BASE_DOWN;
            }
            case UP: {
                return SHAPE_WITH_BASE_UP;
            }
        }
        throw new AssertionError();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BASE, BlockStateProperties.field_208155_H, BlockStateProperties.field_208194_u, ROTATION});
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196010_d().func_176734_d();
        Direction horizontalFacing = context.func_195992_f().func_176734_d();
        Direction base = Arrays.stream(context.func_196009_e()).filter((Predicate<Direction>)Direction.Plane.VERTICAL).findFirst().orElse(Direction.DOWN);
        InternalRotation rotation = InternalRotation.VALUES[4 + Math.floorMod(facing.func_96559_d() * horizontalFacing.func_176736_b(), 4)];
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(BASE, (Comparable)base)).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)facing)).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.FALSE)).func_206870_a(ROTATION, (Comparable)((Object)rotation));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.func_175640_z(pos);
        if (powered != (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        boolean powered;
        if (!oldState.func_203425_a(state.func_177230_c()) && (powered = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        switch (direction) {
            case DOWN: 
            case UP: {
                return (BlockState)state.func_206870_a(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.func_177229_b(ROTATION))).compose(Rotation.CLOCKWISE_180)));
            }
        }
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)mirror.func_185800_a(direction).func_185831_a(direction));
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        switch (direction) {
            case DOWN: 
            case UP: {
                return (BlockState)state.func_206870_a(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.func_177229_b(ROTATION))).compose(rotation)));
            }
        }
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)rotation.func_185831_a(direction));
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.func_201670_d()) {
            if (!ProjectorBlock.hasProjectorPermission((ServerPlayerEntity)player)) {
                return ActionResultType.FAIL;
            }
            ItemStack itemStack = player.func_184586_b(hand);
            if (itemStack.func_77973_b() instanceof FlipperItem) {
                FlipperItem.setProjectorPos(itemStack, pos);
                Utilities.sendOverLayMessage(player, (ITextComponent)Text.translatable("info.slide_show.bound_projector", new Object[0]).func_240699_a_(TextFormatting.AQUA));
                return ActionResultType.CONSUME;
            }
            TileEntity blockEntity = world.func_175625_s(pos);
            if (!(blockEntity instanceof ProjectorBlockEntity)) {
                return ActionResultType.FAIL;
            }
            ProjectorScreenHandler.openScreen((ServerPlayerEntity)player, (ProjectorBlockEntity)blockEntity);
        }
        return ActionResultType.SUCCESS;
    }

    public static boolean hasProjectorPermission(ServerPlayerEntity serverPlayer) {
        return serverPlayer.func_195070_dx();
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    private static boolean hasPermission(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SURVIVAL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ProjectorBlockEntity();
    }

    public static enum InternalRotation implements IStringSerializable
    {
        NONE(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        CLOCKWISE_90(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        CLOCKWISE_180(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        COUNTERCLOCKWISE_90(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        HORIZONTAL_FLIPPED(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        DIAGONAL_FLIPPED(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        VERTICAL_FLIPPED(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}),
        ANTI_DIAGONAL_FLIPPED(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});

        public static final InternalRotation[] VALUES;
        private static final int[] INV_INDICES;
        private static final int[] FLIP_INDICES;
        private static final int[][] ROTATION_INDICES;
        private final String mSerializedName = this.name().toLowerCase(Locale.ROOT);
        private final Matrix4f mMatrix = new Matrix4f();
        private final Matrix3f mNormal;

        private InternalRotation(float[] matrix) {
            InternalRotation.load(this.mMatrix, FloatBuffer.wrap(matrix));
            this.mNormal = new Matrix3f(this.mMatrix);
        }

        public InternalRotation compose(Rotation rotation) {
            return VALUES[ROTATION_INDICES[rotation.ordinal()][this.ordinal()]];
        }

        public InternalRotation flip() {
            return VALUES[FLIP_INDICES[this.ordinal()]];
        }

        public InternalRotation invert() {
            return VALUES[INV_INDICES[this.ordinal()]];
        }

        public boolean isFlipped() {
            return this.ordinal() >= 4;
        }

        public void transform(Vector4f vector) {
            vector.func_229372_a_(this.mMatrix);
        }

        public void transform(Matrix4f poseMatrix) {
            poseMatrix.func_226595_a_(this.mMatrix);
        }

        public void transform(Matrix3f normalMatrix) {
            normalMatrix.func_226118_b_(this.mNormal);
        }

        public final String func_176610_l() {
            return this.mSerializedName;
        }

        private static void load(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            matrix4f.field_226575_a_ = floatBuffer.get(InternalRotation.bufferIndex(0, 0));
            matrix4f.field_226576_b_ = floatBuffer.get(InternalRotation.bufferIndex(0, 1));
            matrix4f.field_226577_c_ = floatBuffer.get(InternalRotation.bufferIndex(0, 2));
            matrix4f.field_226578_d_ = floatBuffer.get(InternalRotation.bufferIndex(0, 3));
            matrix4f.field_226579_e_ = floatBuffer.get(InternalRotation.bufferIndex(1, 0));
            matrix4f.field_226580_f_ = floatBuffer.get(InternalRotation.bufferIndex(1, 1));
            matrix4f.field_226581_g_ = floatBuffer.get(InternalRotation.bufferIndex(1, 2));
            matrix4f.field_226582_h_ = floatBuffer.get(InternalRotation.bufferIndex(1, 3));
            matrix4f.field_226583_i_ = floatBuffer.get(InternalRotation.bufferIndex(2, 0));
            matrix4f.field_226584_j_ = floatBuffer.get(InternalRotation.bufferIndex(2, 1));
            matrix4f.field_226585_k_ = floatBuffer.get(InternalRotation.bufferIndex(2, 2));
            matrix4f.field_226586_l_ = floatBuffer.get(InternalRotation.bufferIndex(2, 3));
            matrix4f.field_226587_m_ = floatBuffer.get(InternalRotation.bufferIndex(3, 0));
            matrix4f.field_226588_n_ = floatBuffer.get(InternalRotation.bufferIndex(3, 1));
            matrix4f.field_226589_o_ = floatBuffer.get(InternalRotation.bufferIndex(3, 2));
            matrix4f.field_226590_p_ = floatBuffer.get(InternalRotation.bufferIndex(3, 3));
        }

        private static int bufferIndex(int i, int j) {
            return j * 4 + i;
        }

        static {
            VALUES = InternalRotation.values();
            INV_INDICES = new int[]{0, 3, 2, 1, 4, 5, 6, 7};
            FLIP_INDICES = new int[]{4, 7, 6, 5, 0, 3, 2, 1};
            ROTATION_INDICES = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 0, 5, 6, 7, 4}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 0, 1, 2, 7, 4, 5, 6}};
        }
    }
}

