/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.Slide;
import org.teacon.slides.renderer.SlideState;

public class ProjectorRenderer
extends TileEntityRenderer<ProjectorBlockEntity> {
    public ProjectorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ProjectorBlockEntity blockEntity, float partialTick, MatrixStack pStack, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        Slide slide = SlideState.getSlide(blockEntity.getLocation(), blockEntity.getFromID());
        if (blockEntity.mSourceType == SourceType.ContainerBlock) {
            SlideState.cacheSlide(blockEntity.mCNextLocation, blockEntity.mCNextFromID);
        }
        if (slide == null) {
            return;
        }
        if (!((Boolean)blockEntity.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
            int color = blockEntity.mColor;
            if ((color & 0xFF000000) == 0) {
                return;
            }
            pStack.func_227860_a_();
            MatrixStack.Entry last = pStack.func_227866_c_();
            Matrix4f pose = last.func_227870_a_();
            Matrix3f normal = last.func_227872_b_();
            BlockState state = blockEntity.func_195044_w();
            Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.func_177229_b(ProjectorBlock.ROTATION));
            pStack.func_227861_a_(0.5, 0.5, 0.5);
            pose.func_226596_a_(direction.func_229384_a_());
            normal.func_226115_a_(direction.func_229384_a_());
            pStack.func_227861_a_(0.0, 0.5, 0.0);
            rotation.transform(pose);
            rotation.transform(normal);
            pStack.func_227861_a_(-0.5, 0.0, (double)(0.5f - blockEntity.mHeight));
            pStack.func_227861_a_((double)blockEntity.mOffsetX, (double)(-blockEntity.mOffsetZ), (double)blockEntity.mOffsetY);
            pose.func_226595_a_(Matrix4f.func_226593_a_((float)blockEntity.mWidth, (float)1.0f, (float)blockEntity.mHeight));
            boolean flipped = ((ProjectorBlock.InternalRotation)((Object)blockEntity.func_195044_w().func_177229_b(ProjectorBlock.ROTATION))).isFlipped();
            slide.render(source, last.func_227870_a_(), last.func_227872_b_(), blockEntity.mWidth, blockEntity.mHeight, color, packedLight, OverlayTexture.field_229196_a_, flipped || blockEntity.mDoubleSided, !flipped || blockEntity.mDoubleSided, SlideState.getAnimationTick(), partialTick);
            pStack.func_227865_b_();
        }
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity p_188185_1_) {
        return true;
    }
}

