/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.NativeImage;
import org.lwjgl.opengl.GL12C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.TextureProvider;
import org.teacon.slides.texture.WebPDecoder;

public final class StaticTextureProvider
implements TextureProvider {
    private int mTexture;
    private final SlideRenderType mRenderType;
    private final int mWidth;
    private final int mHeight;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticTextureProvider(@Nonnull byte[] data, boolean isWebP) {
        ByteBuffer buffer = isWebP ? MemoryUtil.memAlloc((int)0) : MemoryUtil.memAlloc((int)data.length).put(data);
        buffer.rewind();
        try (NativeImage image = isWebP ? WebPDecoder.toNativeImage(data) : NativeImage.func_195704_a((ByteBuffer)buffer);){
            if (image == null) {
                throw new IOException();
            }
            this.mWidth = image.func_195702_a();
            this.mHeight = image.func_195714_b();
            int maxLevel = Math.min(31 - Integer.numberOfLeadingZeros(Math.max(this.mWidth, this.mHeight)), 4);
            this.mTexture = GL12C.glGenTextures();
            GlStateManager.func_227760_t_((int)this.mTexture);
            GL12C.glTexParameteri((int)3553, (int)33082, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33083, (int)maxLevel);
            GL12C.glTexParameteri((int)3553, (int)33084, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33085, (int)maxLevel);
            GL12C.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            for (int level = 0; level <= maxLevel; ++level) {
                GL12C.glTexImage2D((int)3553, (int)level, (int)32856, (int)(this.mWidth >> level), (int)(this.mHeight >> level), (int)0, (int)6403, (int)5121, (IntBuffer)null);
            }
            GL12C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL12C.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL12C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL12C.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL12C.glPixelStorei((int)3314, (int)0);
            GL12C.glPixelStorei((int)3316, (int)0);
            GL12C.glPixelStorei((int)3315, (int)0);
            GL12C.glPixelStorei((int)3317, (int)1);
            try {
                GL12C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)6408, (int)5121, (long)image.field_195722_d);
            }
            catch (Exception exception) {
            }
            finally {
                image.close();
            }
            GL30C.glGenerateMipmap((int)3553);
            this.mRenderType = new SlideRenderType(this.mTexture);
        }
        catch (Throwable t) {
            this.close();
            throw new CompletionException(t);
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    @Override
    @Nonnull
    public SlideRenderType updateAndGet(long tick, float partialTick) {
        return this.mRenderType;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public void close() {
        if (this.mTexture != 0) {
            GlStateManager.func_227758_s_((int)this.mTexture);
        }
        this.mTexture = 0;
    }
}

