/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_241;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.apache.commons.lang3.StringUtils;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPacket;
import org.teacon.slides.network.ProjectorExportC2SPacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.RenderUtils;
import org.teacon.slides.util.Text;

public final class ProjectorScreen
extends class_465<ProjectorScreenHandler> {
    private static final class_2960 GUI_TEXTURE = new class_2960("slide_show", "textures/gui/projector.png");
    private static final class_2561 IMAGE_TEXT = Text.translatable("gui.slide_show.section.image", new Object[0]);
    private static final class_2561 OFFSET_TEXT = Text.translatable("gui.slide_show.section.offset", new Object[0]);
    private static final class_2561 OTHERS_TEXT = Text.translatable("gui.slide_show.section.others", new Object[0]);
    private static final class_2561 URL_TEXT = Text.translatable("gui.slide_show.url", new Object[0]);
    private static final class_2561 ID_TEXT = Text.translatable("gui.slide_show.id", new Object[0]);
    private static final class_2561 EXPORT_TEXT = Text.translatable("gui.slide_show.export", new Object[0]);
    private static final class_2561 CONTAINER_TEXT = Text.translatable("gui.slide_show.container", new Object[0]);
    private static final class_2561 COLOR_TEXT = Text.translatable("gui.slide_show.color", new Object[0]);
    private static final class_2561 WIDTH_TEXT = Text.translatable("gui.slide_show.width", new Object[0]);
    private static final class_2561 HEIGHT_TEXT = Text.translatable("gui.slide_show.height", new Object[0]);
    private static final class_2561 OFFSET_X_TEXT = Text.translatable("gui.slide_show.offset_x", new Object[0]);
    private static final class_2561 OFFSET_Y_TEXT = Text.translatable("gui.slide_show.offset_y", new Object[0]);
    private static final class_2561 OFFSET_Z_TEXT = Text.translatable("gui.slide_show.offset_z", new Object[0]);
    private static final class_2561 FLIP_TEXT = Text.translatable("gui.slide_show.flip", new Object[0]);
    private static final class_2561 ROTATE_TEXT = Text.translatable("gui.slide_show.rotate", new Object[0]);
    private static final class_2561 SINGLE_DOUBLE_SIDED_TEXT = Text.translatable("gui.slide_show.single_double_sided", new Object[0]);
    private class_342 mURLInput;
    private class_342 mColorInput;
    private class_342 mWidthInput;
    private class_342 mHeightInput;
    private class_342 mOffsetXInput;
    private class_342 mOffsetYInput;
    private class_342 mOffsetZInput;
    private class_344 mSwitchURL;
    private class_344 mSwitchID;
    private class_344 mSwitchContainer;
    private class_344 mButtonExport;
    private class_344 mSwitchSingleSided;
    private class_344 mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private class_241 mImageSize = class_241.field_1335;
    private class_1160 mImageOffset = new class_1160();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        this.field_22787.field_1774.method_1462(true);
        int leftPos = (this.field_22789 - this.imageWidth) / 2;
        int topPos = (this.field_22790 - this.imageHeight) / 2;
        this.mURLInput = new class_342(this.field_22793, leftPos + 30, topPos + 29, 137, 16, (class_2561)Text.translatable("gui.slide_show.url", new Object[0]));
        this.mURLInput.method_1880(512);
        this.mURLInput.method_1863(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (class_2960.method_12829((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.method_1868(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.method_1852(this.mEntity.mLocation);
        this.method_37063((class_364)this.mURLInput);
        this.method_20085((class_364)this.mURLInput);
        this.mColorInput = new class_342(this.field_22793, leftPos + 55, topPos + 155, 56, 16, (class_2561)Text.translatable("gui.slide_show.color", new Object[0]));
        this.mColorInput.method_1880(8);
        this.mColorInput.method_1863(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.method_1868(this.mInvalidColor ? 14699339 : 0xE0E0E0);
        });
        this.mColorInput.method_1852(String.format("%08X", this.mEntity.mColor));
        this.method_37063((class_364)this.mColorInput);
        this.mWidthInput = new class_342(this.field_22793, leftPos + 30, topPos + 51, 56, 16, (class_2561)Text.translatable("gui.slide_show.width", new Object[0]));
        this.mWidthInput.method_1863(text -> {
            try {
                class_241 newSize = new class_241(ProjectorScreen.parseFloat(text), this.mImageSize.field_1342);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.method_1868(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
        });
        this.mWidthInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.method_37063((class_364)this.mWidthInput);
        this.mHeightInput = new class_342(this.field_22793, leftPos + 111, topPos + 51, 56, 16, (class_2561)Text.translatable("gui.slide_show.height", new Object[0]));
        this.mHeightInput.method_1863(input -> {
            try {
                class_241 newSize = new class_241(this.mImageSize.field_1343, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.method_1868(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
        });
        this.mHeightInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.method_37063((class_364)this.mHeightInput);
        this.mOffsetXInput = new class_342(this.field_22793, leftPos + 30, topPos + 103, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_x", new Object[0]));
        this.mOffsetXInput.method_1863(input -> {
            try {
                this.mImageOffset = new class_1160(ProjectorScreen.parseFloat(input), this.mImageOffset.method_4945(), this.mImageOffset.method_4947());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.method_1868(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.method_37063((class_364)this.mOffsetXInput);
        this.mOffsetYInput = new class_342(this.field_22793, leftPos + 84, topPos + 103, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_y", new Object[0]));
        this.mOffsetYInput.method_1863(input -> {
            try {
                this.mImageOffset = new class_1160(this.mImageOffset.method_4943(), ProjectorScreen.parseFloat(input), this.mImageOffset.method_4947());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.method_1868(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.method_37063((class_364)this.mOffsetYInput);
        this.mOffsetZInput = new class_342(this.field_22793, leftPos + 138, topPos + 103, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_z", new Object[0]));
        this.mOffsetZInput.method_1863(input -> {
            try {
                this.mImageOffset = new class_1160(this.mImageOffset.method_4943(), this.mImageOffset.method_4945(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.method_1868(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.method_37063((class_364)this.mOffsetZInput);
        this.method_37063((class_364)new class_344(leftPos + 117, topPos + 153, 18, 19, 179, 153, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.method_37063((class_364)new class_344(leftPos + 142, topPos + 153, 18, 19, 179, 173, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(class_2470.field_11463);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.method_11010().method_11654(ProjectorBlock.ROTATION));
        this.mSwitchURL = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 53, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.field_22764 = true;
            this.mSwitchURL.field_22764 = false;
        });
        this.mSwitchID = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 73, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.field_22764 = true;
            this.mSwitchID.field_22764 = false;
            this.mButtonExport.field_22764 = false;
        });
        this.mSwitchContainer = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 93, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.field_22764 = true;
            this.mSwitchContainer.field_22764 = false;
            this.mButtonExport.field_22764 = true;
        });
        this.mButtonExport = new class_344(leftPos + 149, topPos + 7, 18, 19, 179, 33, 0, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new class_344(leftPos + 9, topPos + 153, 18, 19, 179, 113, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchDoubleSided.field_22764 = true;
            this.mSwitchSingleSided.field_22764 = false;
        });
        this.mSwitchDoubleSided = new class_344(leftPos + 9, topPos + 153, 18, 19, 179, 133, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchSingleSided.field_22764 = true;
            this.mSwitchDoubleSided.field_22764 = false;
        });
        this.mSwitchURL.field_22764 = this.mSourceType == SourceType.URL;
        this.mSwitchID.field_22764 = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.field_22764 = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.field_22764 = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.field_22764 = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.field_22764 = !this.mDoubleSided;
        this.method_37063((class_364)this.mSwitchURL);
        this.method_37063((class_364)this.mSwitchID);
        this.method_37063((class_364)this.mSwitchContainer);
        this.method_37063((class_364)this.mButtonExport);
        this.method_37063((class_364)this.mSwitchSingleSided);
        this.method_37063((class_364)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            class_1160 absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            class_1160 newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4943()));
            this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4945()));
            this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4947()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(class_241 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            class_1160 absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            class_1160 newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4943()));
            this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4945()));
            this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(newRelative.method_4947()));
        }
        this.mImageSize = newSize;
    }

    public void method_37432() {
        if (this.mEntity == null) {
            this.field_22787.field_1724.method_7346();
            return;
        }
        this.mURLInput.method_1865();
        this.mColorInput.method_1865();
        this.mWidthInput.method_1865();
        this.mHeightInput.method_1865();
        this.mOffsetXInput.method_1865();
        this.mOffsetYInput.method_1865();
        this.mOffsetZInput.method_1865();
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        new ProjectorExportC2SPacket(this.mSourceType == SourceType.ResourceID, this.mURLInput.method_1882()).sendToServer();
    }

    public void method_25432() {
        boolean invalidOffset;
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.method_1882();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.field_1343;
            this.mEntity.mHeight = this.mImageSize.field_1342;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.method_4943();
            this.mEntity.mOffsetY = this.mImageOffset.method_4945();
            this.mEntity.mOffsetZ = this.mImageOffset.method_4947();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType == this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        new ProjectorAfterUpdateC2SPacket(this.mEntity, this.mRotation).sendToServer();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return this.mURLInput.method_25404(keyCode, scanCode, modifier) || this.mURLInput.method_20315() || this.mColorInput.method_25404(keyCode, scanCode, modifier) || this.mColorInput.method_20315() || this.mWidthInput.method_25404(keyCode, scanCode, modifier) || this.mWidthInput.method_20315() || this.mHeightInput.method_25404(keyCode, scanCode, modifier) || this.mHeightInput.method_20315() || this.mOffsetXInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetXInput.method_20315() || this.mOffsetYInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetYInput.method_20315() || this.mOffsetZInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetZInput.method_20315() || super.method_25404(keyCode, scanCode, modifier);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    protected void method_2389(class_4587 matrixStack, float f, int i, int j) {
        this.method_25420(matrixStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        this.method_25302(matrixStack, (this.field_22789 - this.imageWidth) / 2, (this.field_22790 - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderUtils.setShaderColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            this.method_25302(matrixStack, 38, 131, 180, 194, 10, 10);
            this.method_25302(matrixStack, 82, 159, 180, 194, 17, 17);
        }
        RenderUtils.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.method_25302(matrixStack, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_22793, IMAGE_TEXT, (float)this.imageWidth / 2.0f, -14.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_22793, OFFSET_TEXT, (float)this.imageWidth / 2.0f, 60.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_22793, OTHERS_TEXT, (float)this.imageWidth / 2.0f, 112.0f);
        int offsetX = mouseX - (this.field_22789 - this.imageWidth) / 2;
        int offsetY = mouseY - (this.field_22790 - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            this.method_25424(matrixStack, switch (this.mSourceType) {
                case SourceType.ResourceID -> ID_TEXT;
                case SourceType.ContainerBlock -> CONTAINER_TEXT;
                default -> URL_TEXT;
            }, offsetX, offsetY);
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                this.method_25424(matrixStack, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            this.method_25424(matrixStack, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
            this.method_25424(matrixStack, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 49 && offsetX < 108 && offsetY < 68) {
            this.method_25424(matrixStack, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
            this.method_25424(matrixStack, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
            this.method_25424(matrixStack, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
            this.method_25424(matrixStack, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            this.method_25424(matrixStack, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            this.method_25424(matrixStack, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            this.method_25424(matrixStack, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(class_4587 stack, class_327 renderer, class_2561 string, float x, float y) {
        renderer.method_30883(stack, string, x - (float)renderer.method_27525((class_5348)string) / 2.0f, y, 0x404040);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static class_1160 relativeToAbsolute(class_1160 relatedOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        class_1162 center = new class_1162(0.5f * size.field_1343, 0.0f, 0.5f * size.field_1342, 1.0f);
        center.method_22674(class_1159.method_24021((float)relatedOffset.method_4943(), (float)(-relatedOffset.method_4947()), (float)relatedOffset.method_4945()));
        center.method_22674(class_1159.method_24021((float)-0.5f, (float)0.0f, (float)(0.5f - size.field_1342)));
        rotation.transform(center);
        return new class_1160(center.method_4953(), center.method_4956(), center.method_4957());
    }

    private static class_1160 absoluteToRelative(class_1160 absoluteOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        class_1162 center = new class_1162(absoluteOffset);
        rotation.invert().transform(center);
        center.method_22674(class_1159.method_24021((float)0.5f, (float)0.0f, (float)(-0.5f + size.field_1342)));
        center.method_22674(class_1159.method_24021((float)(-0.5f * size.field_1343), (float)0.0f, (float)(-0.5f * size.field_1342)));
        return new class_1160(center.method_4953(), center.method_4957(), -center.method_4956());
    }
}

