/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.http.impl.client.cache;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.RouteInfo;

@Immutable
class InternalURIUtils {
    public static URI rewriteURIForRoute(URI uri, RouteInfo route) throws URISyntaxException {
        if (uri == null) {
            return null;
        }
        if (route.getProxyHost() != null && !route.isTunnelled()) {
            if (!uri.isAbsolute()) {
                HttpHost target = route.getTargetHost();
                return URIUtils.rewriteURI(uri, target, true);
            }
            return URIUtils.rewriteURI(uri);
        }
        if (uri.isAbsolute()) {
            return URIUtils.rewriteURI(uri, null, true);
        }
        return URIUtils.rewriteURI(uri);
    }

    private InternalURIUtils() {
    }
}

