/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.network.Network;
import org.teacon.slides.util.Utilities;

public final class FlipperFlipBackC2SPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FlipperFlipBackC2SPayload> ID = new CustomPacketPayload.Type(Network.PACKET_FLIP_BACK);
    private final int slot;

    public FlipperFlipBackC2SPayload(int slot) {
        this.slot = slot;
    }

    public FlipperFlipBackC2SPayload(RegistryFriendlyByteBuf buf) {
        this.slot = buf.readInt();
    }

    public static void writeBuffer(FlipperFlipBackC2SPayload payload, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(payload.slot);
    }

    public static void handle(FlipperFlipBackC2SPayload payload, IPayloadContext context) {
        int i = payload.slot;
        ServerPlayer serverPlayer = (ServerPlayer)context.player();
        context.enqueueWork(() -> {
            ItemStack itemStack = serverPlayer.getInventory().getItem(i);
            if (itemStack.is(Slideshow.FLIPPER_ITEM) && FlipperItem.trySendFlip((Level)serverPlayer.serverLevel(), serverPlayer, itemStack, true, false)) {
                return;
            }
            GameProfile profile = serverPlayer.getGameProfile();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for flip back: player = {}", (Object)profile);
        });
    }

    public CustomPacketPayload.Type<FlipperFlipBackC2SPayload> type() {
        return ID;
    }
}

